/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wiremock.org.eclipse.jetty.client.Connection;
import wiremock.org.eclipse.jetty.client.Destination;
import wiremock.org.eclipse.jetty.client.Origin;
import wiremock.org.eclipse.jetty.client.ProxyConfiguration;
import wiremock.org.eclipse.jetty.io.AbstractConnection;
import wiremock.org.eclipse.jetty.io.ClientConnectionFactory;
import wiremock.org.eclipse.jetty.io.ClientConnector;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.Promise;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class Socks4Proxy
extends ProxyConfiguration.Proxy {
    public Socks4Proxy(String host, int port) {
        this(new Origin.Address(host, port), false);
    }

    public Socks4Proxy(Origin.Address address, boolean secure) {
        super(address, secure, null, null);
    }

    @Override
    public ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return new Socks4ProxyClientConnectionFactory(connectionFactory);
    }

    public static class Socks4ProxyClientConnectionFactory
    extends ClientConnectionFactory.Wrapper {
        public Socks4ProxyClientConnectionFactory(ClientConnectionFactory connectionFactory) {
            super(connectionFactory);
        }

        @Override
        public wiremock.org.eclipse.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
            Destination destination = (Destination)context.get(Destination.CONTEXT_KEY);
            Executor executor = destination.getHttpClient().getExecutor();
            Socks4ProxyConnection connection = new Socks4ProxyConnection(endPoint, executor, this.getWrapped(), context);
            return this.customize(connection, context);
        }
    }

    private static class Socks4ProxyConnection
    extends AbstractConnection
    implements Callback {
        private static final Pattern IPv4_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
        private static final Logger LOG = LoggerFactory.getLogger(Socks4ProxyConnection.class);
        private final Socks4Parser parser = new Socks4Parser();
        private final ClientConnectionFactory connectionFactory;
        private final Map<String, Object> context;

        public Socks4ProxyConnection(EndPoint endPoint, Executor executor, ClientConnectionFactory connectionFactory, Map<String, Object> context) {
            super(endPoint, executor);
            this.connectionFactory = connectionFactory;
            this.context = context;
        }

        @Override
        public void onOpen() {
            super.onOpen();
            this.writeSocks4Connect();
        }

        private void writeSocks4Connect() {
            Destination destination = (Destination)this.context.get(Destination.CONTEXT_KEY);
            Origin.Address address = destination.getOrigin().getAddress();
            String host = address.getHost();
            short port = (short)address.getPort();
            Matcher matcher = IPv4_PATTERN.matcher(host);
            if (matcher.matches()) {
                ByteBuffer buffer = ByteBuffer.allocate(9);
                buffer.put((byte)4).put((byte)1).putShort(port);
                for (int i = 1; i <= 4; ++i) {
                    buffer.put((byte)Integer.parseInt(matcher.group(i)));
                }
                buffer.put((byte)0);
                buffer.flip();
                this.getEndPoint().write((Callback)this, buffer);
            } else {
                byte[] hostBytes = host.getBytes(StandardCharsets.UTF_8);
                ByteBuffer buffer = ByteBuffer.allocate(9 + hostBytes.length + 1);
                buffer.put((byte)4).put((byte)1).putShort(port);
                buffer.put((byte)0).put((byte)0).put((byte)0).put((byte)1).put((byte)0);
                buffer.put(hostBytes).put((byte)0);
                buffer.flip();
                this.getEndPoint().write((Callback)this, buffer);
            }
        }

        @Override
        public void succeeded() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Written SOCKS4 connect request");
            }
            this.fillInterested();
        }

        @Override
        public void failed(Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("SOCKS4 failure");
            }
            this.getEndPoint().close(x);
            Promise promise = (Promise)this.context.get(Connection.PROMISE_CONTEXT_KEY);
            promise.failed(x);
        }

        @Override
        public boolean onIdleExpired(TimeoutException timeout) {
            this.failed(timeout);
            return false;
        }

        @Override
        public void onFillable() {
            try {
                ByteBuffer buffer;
                do {
                    buffer = BufferUtil.allocate(this.parser.expected());
                    int filled = this.getEndPoint().fill(buffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Read SOCKS4 connect response, {} bytes", (Object)filled);
                    }
                    if (filled < 0) {
                        throw new IOException("SOCKS4 tunnel failed, connection closed");
                    }
                    if (filled != 0) continue;
                    this.fillInterested();
                    return;
                } while (!this.parser.parse(buffer));
                return;
            }
            catch (Throwable x) {
                this.failed(x);
                return;
            }
        }

        private void onSocks4Response(int responseCode) throws IOException {
            if (responseCode != 90) {
                throw new IOException("SOCKS4 tunnel failed with code " + responseCode);
            }
            this.tunnel();
        }

        private void tunnel() {
            try {
                Destination destination = (Destination)this.context.get(Destination.CONTEXT_KEY);
                Origin.Address address = destination.getOrigin().getAddress();
                InetSocketAddress inet = InetSocketAddress.createUnresolved(address.getHost(), address.getPort());
                this.context.put(ClientConnector.REMOTE_SOCKET_ADDRESS_CONTEXT_KEY, inet);
                ClientConnectionFactory connectionFactory = this.connectionFactory;
                if (destination.isSecure()) {
                    connectionFactory = destination.getHttpClient().getClientConnector().newSslClientConnectionFactory(null, connectionFactory);
                }
                wiremock.org.eclipse.jetty.io.Connection newConnection = connectionFactory.newConnection(this.getEndPoint(), this.context);
                this.getEndPoint().upgrade(newConnection);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SOCKS4 tunnel established: {} over {}", (Object)this, (Object)newConnection);
                }
            }
            catch (Throwable x) {
                this.failed(x);
            }
        }

        private class Socks4Parser {
            private static final int EXPECTED_LENGTH = 8;
            private int cursor;
            private int response;

            private Socks4Parser() {
            }

            private boolean parse(ByteBuffer buffer) throws IOException {
                while (buffer.hasRemaining()) {
                    byte current = buffer.get();
                    if (this.cursor == 1) {
                        this.response = current & 0xFF;
                    }
                    ++this.cursor;
                    if (this.cursor != 8) continue;
                    Socks4ProxyConnection.this.onSocks4Response(this.response);
                    return true;
                }
                return false;
            }

            private int expected() {
                return 8 - this.cursor;
            }
        }
    }
}

