/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client;

import java.util.function.ToIntFunction;
import wiremock.org.eclipse.jetty.client.AbstractConnectionPool;
import wiremock.org.eclipse.jetty.client.Connection;
import wiremock.org.eclipse.jetty.client.ConnectionPool;
import wiremock.org.eclipse.jetty.client.Destination;
import wiremock.org.eclipse.jetty.util.ConcurrentPool;
import wiremock.org.eclipse.jetty.util.Pool;
import wiremock.org.eclipse.jetty.util.annotation.ManagedAttribute;
import wiremock.org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public class MultiplexConnectionPool
extends AbstractConnectionPool {
    public static ToIntFunction<Connection> newMaxMultiplexer(int defaultMaxMultiplex) {
        return connection -> {
            int maxMultiplex = defaultMaxMultiplex;
            if (connection instanceof ConnectionPool.MaxMultiplexable) {
                ConnectionPool.MaxMultiplexable maxMultiplexable = (ConnectionPool.MaxMultiplexable)((Object)connection);
                maxMultiplex = maxMultiplexable.getMaxMultiplex();
            }
            return maxMultiplex;
        };
    }

    public MultiplexConnectionPool(Destination destination, int maxConnections, int initialMaxMultiplex) {
        this(destination, () -> new ConcurrentPool<Connection>(ConcurrentPool.StrategyType.FIRST, maxConnections, MultiplexConnectionPool.newMaxMultiplexer(initialMaxMultiplex)), initialMaxMultiplex);
    }

    protected MultiplexConnectionPool(Destination destination, Pool.Factory<Connection> poolFactory, int initialMaxMultiplex) {
        super(destination, poolFactory, initialMaxMultiplex);
    }

    @Override
    @ManagedAttribute(value="The initial multiplexing factor of connections")
    public int getInitialMaxMultiplex() {
        return super.getInitialMaxMultiplex();
    }

    @Override
    public void setInitialMaxMultiplex(int initialMaxMultiplex) {
        super.setInitialMaxMultiplex(initialMaxMultiplex);
    }
}

