/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import wiremock.org.eclipse.jetty.client.Connection;
import wiremock.org.eclipse.jetty.client.Destination;
import wiremock.org.eclipse.jetty.client.HttpClient;
import wiremock.org.eclipse.jetty.client.HttpResponseException;
import wiremock.org.eclipse.jetty.client.Origin;
import wiremock.org.eclipse.jetty.client.ProxyConfiguration;
import wiremock.org.eclipse.jetty.client.Request;
import wiremock.org.eclipse.jetty.client.Response;
import wiremock.org.eclipse.jetty.client.Result;
import wiremock.org.eclipse.jetty.client.internal.TunnelRequest;
import wiremock.org.eclipse.jetty.client.transport.HttpConversation;
import wiremock.org.eclipse.jetty.client.transport.HttpDestination;
import wiremock.org.eclipse.jetty.client.transport.HttpRequest;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.io.ClientConnectionFactory;
import wiremock.org.eclipse.jetty.io.ClientConnector;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.Transport;
import wiremock.org.eclipse.jetty.util.Attachable;
import wiremock.org.eclipse.jetty.util.Promise;
import wiremock.org.eclipse.jetty.util.ssl.SslContextFactory;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class HttpProxy
extends ProxyConfiguration.Proxy {
    private static final Logger LOG = LoggerFactory.getLogger(HttpProxy.class);

    public HttpProxy(String host, int port) {
        this(new Origin.Address(host, port), false);
    }

    public HttpProxy(Origin.Address address, boolean secure) {
        this(address, secure, new Origin.Protocol(List.of("http/1.1"), false));
    }

    public HttpProxy(Origin.Address address, boolean secure, Origin.Protocol protocol) {
        this(new Origin(secure ? "https" : "http", address, null, protocol, Transport.TCP_IP), null);
    }

    public HttpProxy(Origin.Address address, SslContextFactory.Client sslContextFactory) {
        this(address, sslContextFactory, new Origin.Protocol(List.of("http/1.1"), false));
    }

    public HttpProxy(Origin.Address address, SslContextFactory.Client sslContextFactory, Origin.Protocol protocol) {
        this(new Origin(sslContextFactory == null ? "http" : "https", address, null, protocol, Transport.TCP_IP), sslContextFactory);
    }

    public HttpProxy(Origin origin, SslContextFactory.Client sslContextFactory) {
        super(origin, sslContextFactory);
    }

    @Override
    public ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return new HttpProxyClientConnectionFactory(connectionFactory);
    }

    @Override
    public URI getURI() {
        return URI.create(this.getOrigin().asString());
    }

    public boolean requiresTunnel(Origin serverOrigin) {
        if (serverOrigin.isSecure()) {
            return true;
        }
        Origin.Protocol serverProtocol = serverOrigin.getProtocol();
        if (serverProtocol == null) {
            return true;
        }
        List<String> serverProtocols = serverProtocol.getProtocols();
        return this.getProtocol().getProtocols().stream().noneMatch(p -> this.protocolMatches((String)p, serverProtocols));
    }

    private boolean protocolMatches(String protocol, List<String> protocols) {
        return protocols.stream().anyMatch(p -> protocol.equalsIgnoreCase((String)p) || this.isHTTP2((String)p) && this.isHTTP2(protocol));
    }

    private boolean isHTTP2(String protocol) {
        return "h2".equalsIgnoreCase(protocol) || "h2c".equalsIgnoreCase(protocol);
    }

    private class HttpProxyClientConnectionFactory
    extends ClientConnectionFactory.Wrapper {
        private HttpProxyClientConnectionFactory(ClientConnectionFactory connectionFactory) {
            super(connectionFactory);
        }

        @Override
        public wiremock.org.eclipse.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
            HttpDestination destination = (HttpDestination)context.get(Destination.CONTEXT_KEY);
            if (HttpProxy.this.requiresTunnel(destination.getOrigin())) {
                return this.newProxyConnection(endPoint, context);
            }
            return this.getWrapped().newConnection(endPoint, context);
        }

        private wiremock.org.eclipse.jetty.io.Connection newProxyConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
            HttpDestination destination = (HttpDestination)context.get(Destination.CONTEXT_KEY);
            HttpClient client = destination.getHttpClient();
            Destination proxyDestination = client.resolveDestination(HttpProxy.this.getOrigin());
            context.put(Destination.CONTEXT_KEY, proxyDestination);
            Promise promise = (Promise)context.get(Connection.PROMISE_CONTEXT_KEY);
            CreateTunnelPromise tunnelPromise = new CreateTunnelPromise(this.getWrapped(), endPoint, destination, promise, context);
            context.put(Connection.PROMISE_CONTEXT_KEY, tunnelPromise);
            return this.getWrapped().newConnection(endPoint, context);
        }
    }

    private static class TunnelPromise
    implements Promise<Connection> {
        private final Request request;
        private final Response.CompleteListener listener;
        private final Promise<Connection> promise;

        private TunnelPromise(Request request, Response.CompleteListener listener, Promise<Connection> promise) {
            this.request = request;
            this.listener = listener;
            this.promise = promise;
        }

        @Override
        public void succeeded(Connection connection) {
            connection.send(this.request, this.listener);
        }

        @Override
        public void failed(Throwable x) {
            this.promise.failed(x);
        }
    }

    private static class ProxyConnection
    implements Connection,
    Attachable {
        private final Destination destination;
        private final Connection connection;
        private final Promise<Connection> promise;
        private Object attachment;

        private ProxyConnection(Destination destination, Connection connection, Promise<Connection> promise) {
            this.destination = destination;
            this.connection = connection;
            this.promise = promise;
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.connection.getLocalSocketAddress();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.connection.getRemoteSocketAddress();
        }

        @Override
        public EndPoint.SslSessionData getSslSessionData() {
            return this.connection.getSslSessionData();
        }

        @Override
        public void send(Request request, Response.CompleteListener listener) {
            if (this.connection.isClosed()) {
                this.destination.newConnection(new TunnelPromise(request, listener, this.promise));
            } else {
                this.connection.send(request, listener);
            }
        }

        @Override
        public void close() {
            this.connection.close();
        }

        @Override
        public boolean isClosed() {
            return this.connection.isClosed();
        }

        @Override
        public void setAttachment(Object obj) {
            this.attachment = obj;
        }

        @Override
        public Object getAttachment() {
            return this.attachment;
        }
    }

    private static class CreateTunnelPromise
    implements Promise<Connection> {
        private final ClientConnectionFactory connectionFactory;
        private final EndPoint endPoint;
        private final HttpDestination destination;
        private final Promise<Connection> promise;
        private final Map<String, Object> context;

        private CreateTunnelPromise(ClientConnectionFactory connectionFactory, EndPoint endPoint, HttpDestination destination, Promise<Connection> promise, Map<String, Object> context) {
            this.connectionFactory = connectionFactory;
            this.endPoint = endPoint;
            this.destination = destination;
            this.promise = promise;
            this.context = context;
        }

        @Override
        public void succeeded(Connection connection) {
            this.context.put(Destination.CONTEXT_KEY, this.destination);
            this.context.put(Connection.PROMISE_CONTEXT_KEY, this.promise);
            this.tunnel(connection);
        }

        @Override
        public void failed(Throwable x) {
            this.tunnelFailed(this.endPoint, x);
        }

        private void tunnel(Connection connection) {
            String target = this.destination.getOrigin().getAddress().asString();
            HttpClient httpClient = this.destination.getHttpClient();
            long connectTimeout = httpClient.getConnectTimeout();
            Request connect = new TunnelRequest(httpClient, this.destination.getProxy().getURI()).path(target).headers(headers -> headers.put(HttpHeader.HOST, target)).timeout(connectTimeout, TimeUnit.MILLISECONDS);
            Destination proxyDestination = httpClient.resolveDestination(this.destination.getProxy().getOrigin());
            connect.attribute(Connection.class.getName(), new ProxyConnection(proxyDestination, connection, this.promise));
            connection.send(connect, new TunnelListener(connect));
        }

        private void tunnelSucceeded(EndPoint endPoint) {
            try {
                HttpDestination destination = (HttpDestination)this.context.get(Destination.CONTEXT_KEY);
                HttpClient httpClient = destination.getHttpClient();
                ClientConnectionFactory factory = this.connectionFactory;
                this.context.put(ClientConnectionFactory.class.getName(), factory);
                InetSocketAddress address = InetSocketAddress.createUnresolved(destination.getHost(), destination.getPort());
                this.context.put(ClientConnector.REMOTE_SOCKET_ADDRESS_CONTEXT_KEY, address);
                SslContextFactory.Client sslContextFactory = destination.isSecure() ? httpClient.getSslContextFactory() : null;
                this.context.compute(ClientConnector.SSL_CONTEXT_FACTORY_CONTEXT_KEY, (k, v) -> sslContextFactory);
                factory = httpClient.newClientConnectionFactory(this.context);
                wiremock.org.eclipse.jetty.io.Connection oldConnection = endPoint.getConnection();
                wiremock.org.eclipse.jetty.io.Connection newConnection = factory.newConnection(endPoint, this.context);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("HTTP tunnel established: {} over {}", (Object)oldConnection, (Object)newConnection);
                }
                endPoint.upgrade(newConnection);
            }
            catch (Throwable x) {
                this.tunnelFailed(endPoint, x);
            }
        }

        private void tunnelFailed(EndPoint endPoint, Throwable failure) {
            endPoint.close(failure);
            this.promise.failed(failure);
        }

        private class TunnelListener
        implements Response.Listener {
            private final HttpConversation conversation;

            private TunnelListener(Request request) {
                this.conversation = ((HttpRequest)request).getConversation();
            }

            @Override
            public void onHeaders(Response response) {
                EndPoint endPoint = (EndPoint)this.conversation.getAttribute(EndPoint.class.getName());
                if (response.getStatus() == 200) {
                    CreateTunnelPromise.this.tunnelSucceeded(endPoint);
                } else {
                    HttpResponseException failure = new HttpResponseException("Unexpected " + String.valueOf(response) + " for " + String.valueOf(response.getRequest()), response);
                    CreateTunnelPromise.this.tunnelFailed(endPoint, failure);
                }
            }

            @Override
            public void onComplete(Result result) {
                if (result.isFailed()) {
                    CreateTunnelPromise.this.tunnelFailed(CreateTunnelPromise.this.endPoint, result.getFailure());
                }
            }
        }
    }
}

