/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.alpn.java.client;

import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import wiremock.org.eclipse.jetty.alpn.client.ALPNClientConnection;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.ssl.ALPNProcessor;
import wiremock.org.eclipse.jetty.io.ssl.SslConnection;
import wiremock.org.eclipse.jetty.io.ssl.SslHandshakeListener;
import wiremock.org.eclipse.jetty.util.JavaVersion;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class JDK9ClientALPNProcessor
implements ALPNProcessor.Client {
    private static final Logger LOG = LoggerFactory.getLogger(JDK9ClientALPNProcessor.class);

    @Override
    public void init() {
        if (JavaVersion.VERSION.getPlatform() < 9) {
            throw new IllegalStateException(String.valueOf(this) + " not applicable for java " + String.valueOf(JavaVersion.VERSION));
        }
    }

    @Override
    public boolean appliesTo(SSLEngine sslEngine) {
        Module module = sslEngine.getClass().getModule();
        return module != null && "java.base".equals(module.getName());
    }

    @Override
    public void configure(SSLEngine sslEngine, Connection connection) {
        ALPNClientConnection alpn = (ALPNClientConnection)connection;
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        List<String> protocols = alpn.getProtocols();
        sslParameters.setApplicationProtocols(protocols.toArray(new String[0]));
        sslEngine.setSSLParameters(sslParameters);
        SslConnection.SslEndPoint sslEndPoint = (SslConnection.SslEndPoint)connection.getEndPoint();
        sslEndPoint.getSslConnection().addHandshakeListener(new ALPNListener(alpn));
    }

    private static final class ALPNListener
    implements SslHandshakeListener {
        private final ALPNClientConnection alpnConnection;

        private ALPNListener(ALPNClientConnection connection) {
            this.alpnConnection = connection;
        }

        @Override
        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            String protocol = this.alpnConnection.getSSLEngine().getApplicationProtocol();
            if (LOG.isDebugEnabled()) {
                LOG.debug("selected protocol '{}'", (Object)protocol);
            }
            if (protocol != null && !protocol.isEmpty()) {
                this.alpnConnection.selected(protocol);
            } else {
                this.alpnConnection.selected(null);
            }
        }
    }
}

