/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http.impl.nio;

import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.HttpRequest;
import wiremock.org.apache.hc.core5.http.config.Http1Config;
import wiremock.org.apache.hc.core5.http.impl.nio.DefaultHttpRequestWriter;
import wiremock.org.apache.hc.core5.http.message.BasicLineFormatter;
import wiremock.org.apache.hc.core5.http.message.LineFormatter;
import wiremock.org.apache.hc.core5.http.nio.NHttpMessageWriter;
import wiremock.org.apache.hc.core5.http.nio.NHttpMessageWriterFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestWriterFactory
implements NHttpMessageWriterFactory<HttpRequest> {
    public static final DefaultHttpRequestWriterFactory INSTANCE = new DefaultHttpRequestWriterFactory();
    private final Http1Config http1Config;
    private final LineFormatter lineFormatter;

    public DefaultHttpRequestWriterFactory(Http1Config http1Config, LineFormatter lineFormatter) {
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.lineFormatter = lineFormatter != null ? lineFormatter : BasicLineFormatter.INSTANCE;
    }

    public DefaultHttpRequestWriterFactory(Http1Config http1Config) {
        this(http1Config, null);
    }

    public DefaultHttpRequestWriterFactory(LineFormatter lineFormatter) {
        this(null, lineFormatter);
    }

    public DefaultHttpRequestWriterFactory() {
        this(null, null);
    }

    @Override
    public NHttpMessageWriter<HttpRequest> create() {
        return new DefaultHttpRequestWriter<HttpRequest>(this.http1Config, this.lineFormatter);
    }
}

