/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.commons.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntUnaryOperator;
import wiremock.org.apache.commons.lang3.ArrayUtils;
import wiremock.org.apache.commons.lang3.Validate;
import wiremock.org.apache.commons.text.CharacterPredicate;
import wiremock.org.apache.commons.text.TextRandomProvider;

public final class RandomStringGenerator {
    private final int minimumCodePoint;
    private final int maximumCodePoint;
    private final Set<CharacterPredicate> inclusivePredicates;
    private final IntUnaryOperator random;
    private final List<Character> characterList;

    public static Builder builder() {
        return new Builder();
    }

    private RandomStringGenerator(Builder builder) {
        this.minimumCodePoint = builder.minimumCodePoint;
        this.maximumCodePoint = builder.maximumCodePoint;
        this.inclusivePredicates = builder.inclusivePredicates;
        this.random = builder.random;
        this.characterList = new ArrayList<Character>(builder.characterSet);
    }

    public String generate(int length) {
        if (length == 0) {
            return "";
        }
        Validate.isTrue(length > 0, "Length %d is smaller than zero.", length);
        StringBuilder builder = new StringBuilder(length);
        long remaining = length;
        block3: do {
            int codePoint = this.characterList != null && !this.characterList.isEmpty() ? this.generateRandomNumber(this.characterList) : this.generateRandomNumber(this.minimumCodePoint, this.maximumCodePoint);
            switch (Character.getType(codePoint)) {
                case 0: 
                case 18: 
                case 19: {
                    break;
                }
                default: {
                    if (this.inclusivePredicates != null) {
                        boolean matchedFilter = false;
                        for (CharacterPredicate predicate : this.inclusivePredicates) {
                            if (!predicate.test(codePoint)) continue;
                            matchedFilter = true;
                            break;
                        }
                        if (!matchedFilter) continue block3;
                    }
                    builder.appendCodePoint(codePoint);
                    --remaining;
                }
            }
        } while (remaining != 0L);
        return builder.toString();
    }

    public String generate(int minLengthInclusive, int maxLengthInclusive) {
        Validate.isTrue(minLengthInclusive >= 0, "Minimum length %d is smaller than zero.", minLengthInclusive);
        Validate.isTrue(minLengthInclusive <= maxLengthInclusive, "Maximum length %d is smaller than minimum length %d.", maxLengthInclusive, minLengthInclusive);
        return this.generate(this.generateRandomNumber(minLengthInclusive, maxLengthInclusive));
    }

    private int generateRandomNumber(int minInclusive, int maxInclusive) {
        if (this.random != null) {
            return this.random.applyAsInt(maxInclusive - minInclusive + 1) + minInclusive;
        }
        return ThreadLocalRandom.current().nextInt(minInclusive, maxInclusive + 1);
    }

    private int generateRandomNumber(List<Character> characterList) {
        int listSize = characterList.size();
        if (this.random != null) {
            return String.valueOf(characterList.get(this.random.applyAsInt(listSize))).codePointAt(0);
        }
        return String.valueOf(characterList.get(ThreadLocalRandom.current().nextInt(0, listSize))).codePointAt(0);
    }

    public static class Builder
    implements wiremock.org.apache.commons.text.Builder<RandomStringGenerator> {
        public static final int DEFAULT_MAXIMUM_CODE_POINT = 0x10FFFF;
        public static final int DEFAULT_LENGTH = 0;
        public static final int DEFAULT_MINIMUM_CODE_POINT = 0;
        private int minimumCodePoint = 0;
        private int maximumCodePoint = 0x10FFFF;
        private Set<CharacterPredicate> inclusivePredicates;
        private IntUnaryOperator random;
        private Set<Character> characterSet = new HashSet<Character>();
        private boolean accumulate;

        @Override
        @Deprecated
        public RandomStringGenerator build() {
            return this.get();
        }

        public Builder filteredBy(CharacterPredicate ... predicates) {
            if (ArrayUtils.isEmpty(predicates)) {
                this.inclusivePredicates = null;
                return this;
            }
            if (this.inclusivePredicates == null) {
                this.inclusivePredicates = new HashSet<CharacterPredicate>();
            } else {
                this.inclusivePredicates.clear();
            }
            Collections.addAll(this.inclusivePredicates, predicates);
            return this;
        }

        @Override
        public RandomStringGenerator get() {
            return new RandomStringGenerator(this);
        }

        private void initCharList() {
            if (!this.accumulate) {
                this.characterSet = new HashSet<Character>();
            }
        }

        public Builder selectFrom(char ... chars) {
            this.initCharList();
            if (chars != null) {
                for (char c : chars) {
                    this.characterSet.add(Character.valueOf(c));
                }
            }
            return this;
        }

        public Builder setAccumulate(boolean accumulate) {
            this.accumulate = accumulate;
            return this;
        }

        public Builder usingRandom(IntUnaryOperator random) {
            this.random = random;
            return this;
        }

        public Builder usingRandom(TextRandomProvider random) {
            this.random = random;
            return this;
        }

        public Builder withinRange(char[] ... pairs) {
            this.initCharList();
            if (pairs != null) {
                for (char[] pair : pairs) {
                    Validate.isTrue(pair.length == 2, "Each pair must contain minimum and maximum code point", new Object[0]);
                    int minimumCodePoint = pair[0];
                    char maximumCodePoint = pair[1];
                    Validate.isTrue(minimumCodePoint <= maximumCodePoint, "Minimum code point %d is larger than maximum code point %d", minimumCodePoint, maximumCodePoint);
                    for (int index = minimumCodePoint; index <= maximumCodePoint; ++index) {
                        this.characterSet.add(Character.valueOf((char)index));
                    }
                }
            }
            return this;
        }

        public Builder withinRange(int minimumCodePoint, int maximumCodePoint) {
            Validate.isTrue(minimumCodePoint <= maximumCodePoint, "Minimum code point %d is larger than maximum code point %d", minimumCodePoint, maximumCodePoint);
            Validate.isTrue(minimumCodePoint >= 0, "Minimum code point %d is negative", minimumCodePoint);
            Validate.isTrue(maximumCodePoint <= 0x10FFFF, "Value %d is larger than Character.MAX_CODE_POINT.", maximumCodePoint);
            this.minimumCodePoint = minimumCodePoint;
            this.maximumCodePoint = maximumCodePoint;
            return this;
        }
    }
}

