/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core.internal;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import wiremock.org.jspecify.annotations.Nullable;

abstract class PathMatcher {
    private static final PathMatcher EMPTY = new PathMatcher(){

        @Override
        boolean matches(String pathToMatch) {
            return false;
        }
    };

    PathMatcher() {
    }

    abstract boolean matches(String var1);

    static PathMatcher create(@Nullable Collection<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return EMPTY;
        }
        List<PathMatcher> matchers = paths.stream().map(PathMatcher::create).collect(Collectors.toList());
        return new AggregatePathMatcher(matchers);
    }

    static PathMatcher create(String path) {
        if (path.contains("[*]")) {
            return new ArrayWildcardMatcher(path);
        }
        return new SimplePathMatcher(path);
    }

    private static class AggregatePathMatcher
    extends PathMatcher {
        private final Collection<PathMatcher> pathMatchers;

        private AggregatePathMatcher(Collection<PathMatcher> pathMatchers) {
            this.pathMatchers = pathMatchers;
        }

        @Override
        boolean matches(String path) {
            return this.pathMatchers.stream().anyMatch(pm -> pm.matches(path));
        }
    }

    private static class ArrayWildcardMatcher
    extends PathMatcher {
        private final Pattern pattern;

        ArrayWildcardMatcher(String path) {
            int to;
            StringBuilder regexp = new StringBuilder();
            int from = 0;
            while ((to = path.indexOf("[*]", from)) >= 0) {
                regexp.append("\\Q").append(path, from, to).append("\\E").append("\\[\\d+\\]");
                from = to + 3;
            }
            if (from < path.length()) {
                regexp.append("\\Q").append(path.substring(from)).append("\\E");
            }
            this.pattern = Pattern.compile(regexp.toString());
        }

        @Override
        boolean matches(String pathToMatch) {
            return this.pattern.matcher(pathToMatch).matches();
        }
    }

    private static class SimplePathMatcher
    extends PathMatcher {
        private final String path;

        SimplePathMatcher(String path) {
            this.path = path;
        }

        @Override
        boolean matches(String pathToMatch) {
            return this.path.equals(pathToMatch) || this.path.startsWith("$.") && this.path.substring(2).equals(pathToMatch) || this.path.startsWith("$[") && this.path.substring(1).equals(pathToMatch);
        }
    }
}

