/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import wiremock.net.javacrumbs.jsonunit.core.internal.Node;

class Normalizer {
    private static final int depth = 2;

    Normalizer() {
    }

    static String toNormalizedString(Node node, Node expected) {
        StringBuilder sb = new StringBuilder();
        Normalizer.normalize(node, expected, sb, 0);
        return sb.toString();
    }

    private static void normalize(Node node, Node expected, StringBuilder sb, int indent) {
        switch (node.getNodeType()) {
            case OBJECT: {
                Normalizer.normalizeObject(node, expected, sb, indent);
                break;
            }
            case ARRAY: {
                Normalizer.normalizeArray(node, expected, sb, indent);
                break;
            }
            default: {
                sb.append(node);
            }
        }
    }

    private static void normalizeArray(Node node, Node expected, StringBuilder sb, int indent) {
        sb.append("[\n");
        Iterator<Node> elements = node.arrayElements();
        int i = 0;
        while (elements.hasNext()) {
            Node element = elements.next();
            Normalizer.addIndent(sb, indent + 2);
            Normalizer.normalize(element, expected.element(i), sb, indent + 2);
            if (elements.hasNext()) {
                sb.append(",");
            }
            sb.append('\n');
        }
        Normalizer.addIndent(sb, indent);
        sb.append("]");
    }

    private static void normalizeObject(Node node, Node expected, StringBuilder sb, int indent) {
        sb.append("{\n");
        Iterator<Object> expectedValues = expected.isObject() ? expected.fields() : Collections.emptyIterator();
        ArrayList<Node.KeyValue> toBePrinted = new ArrayList<Node.KeyValue>();
        HashSet<String> processedKeys = new HashSet<String>();
        while (expectedValues.hasNext()) {
            String key = ((Node.KeyValue)expectedValues.next()).getKey();
            Node value = node.get(key);
            if (value.isMissingNode()) continue;
            toBePrinted.add(new Node.KeyValue(key, value));
            processedKeys.add(key);
        }
        Iterator<Node.KeyValue> nodeFields = node.fields();
        while (nodeFields.hasNext()) {
            Node.KeyValue keyValue = nodeFields.next();
            if (processedKeys.contains(keyValue.getKey())) continue;
            toBePrinted.add(keyValue);
        }
        Iterator toBePrintedIterator = toBePrinted.iterator();
        while (toBePrintedIterator.hasNext()) {
            Node.KeyValue keyValue = (Node.KeyValue)toBePrintedIterator.next();
            Normalizer.addIndent(sb, indent + 2);
            sb.append('\"').append(keyValue.getKey()).append("\": ");
            Normalizer.normalize(keyValue.getValue(), expected.get(keyValue.getKey()), sb, indent + 2);
            if (toBePrintedIterator.hasNext()) {
                sb.append(",");
            }
            sb.append('\n');
        }
        Normalizer.addIndent(sb, indent);
        sb.append("}");
    }

    private static void addIndent(StringBuilder sb, int indent) {
        sb.append(" ".repeat(Math.max(0, indent)));
    }
}

