/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core.internal;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.databind.DeserializationFeature;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.ObjectMapper;
import wiremock.com.fasterxml.jackson.databind.cfg.JsonNodeFeature;
import wiremock.com.fasterxml.jackson.databind.node.NullNode;
import wiremock.net.javacrumbs.jsonunit.core.internal.AbstractNode;
import wiremock.net.javacrumbs.jsonunit.core.internal.AbstractNodeFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.Node;
import wiremock.net.javacrumbs.jsonunit.core.internal.Utils;
import wiremock.net.javacrumbs.jsonunit.providers.Jackson2ObjectMapperProvider;
import wiremock.org.jspecify.annotations.Nullable;

class Jackson2NodeFactory
extends AbstractNodeFactory {
    private final ServiceLoader<Jackson2ObjectMapperProvider> serviceLoader = ServiceLoader.load(Jackson2ObjectMapperProvider.class);

    Jackson2NodeFactory() {
    }

    @Override
    protected Node doConvertValue(Object source) {
        if (source instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)source;
            return Jackson2NodeFactory.newNode(jsonNode);
        }
        return Jackson2NodeFactory.newNode(this.getMapper(false).convertValue(source, JsonNode.class));
    }

    @Override
    protected Node nullNode() {
        return Jackson2NodeFactory.newNode(NullNode.getInstance());
    }

    @Override
    protected Node readValue(Reader value, String label, boolean lenient) {
        try {
            Node node = Jackson2NodeFactory.newNode(this.getMapper(lenient).readTree(value));
            return node;
        }
        catch (IOException e) {
            throw this.newParseException(label, value, e);
        }
        finally {
            Utils.closeQuietly(value);
        }
    }

    private ObjectMapper getMapper(boolean lenient) {
        return this.getMapperProvider().getObjectMapper(lenient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jackson2ObjectMapperProvider getMapperProvider() {
        ServiceLoader<Jackson2ObjectMapperProvider> serviceLoader = this.serviceLoader;
        synchronized (serviceLoader) {
            Iterator<Jackson2ObjectMapperProvider> iterator = this.serviceLoader.iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return DefaultObjectMapperProvider.INSTANCE;
        }
    }

    private static Node newNode(@Nullable JsonNode jsonNode) {
        if (jsonNode != null && !jsonNode.isMissingNode()) {
            return new Jackson2Node(jsonNode);
        }
        return Node.MISSING_NODE;
    }

    @Override
    public boolean isPreferredFor(@Nullable Object source) {
        return source instanceof JsonNode;
    }

    private static class DefaultObjectMapperProvider
    implements Jackson2ObjectMapperProvider {
        static final Jackson2ObjectMapperProvider INSTANCE = new DefaultObjectMapperProvider();
        private static final ObjectMapper mapper = new ObjectMapper().findAndRegisterModules();
        private static final ObjectMapper lenientMapper = new ObjectMapper().findAndRegisterModules();

        private DefaultObjectMapperProvider() {
        }

        @Override
        public ObjectMapper getObjectMapper(boolean lenient) {
            return lenient ? lenientMapper : mapper;
        }

        static {
            mapper.configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, true);
            mapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
            mapper.configure(JsonNodeFeature.STRIP_TRAILING_BIGDECIMAL_ZEROES, false);
            lenientMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            lenientMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            lenientMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            lenientMapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
            lenientMapper.configure(JsonNodeFeature.STRIP_TRAILING_BIGDECIMAL_ZEROES, false);
        }
    }

    static final class Jackson2Node
    extends AbstractNode {
        private final JsonNode jsonNode;

        Jackson2Node(JsonNode jsonNode) {
            this.jsonNode = jsonNode;
        }

        @Override
        public Node element(int index) {
            return Jackson2NodeFactory.newNode(this.jsonNode.path(index));
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            final Iterator<Map.Entry<String, JsonNode>> iterator = this.jsonNode.properties().iterator();
            return new Iterator<Node.KeyValue>(this){
                final /* synthetic */ Jackson2Node this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Node.KeyValue next() {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    return new Node.KeyValue((String)entry.getKey(), Jackson2NodeFactory.newNode((JsonNode)entry.getValue()));
                }
            };
        }

        @Override
        public Node get(String key) {
            return Jackson2NodeFactory.newNode(this.jsonNode.get(key));
        }

        @Override
        public boolean isMissingNode() {
            return false;
        }

        @Override
        public boolean isNull() {
            return this.jsonNode.isNull();
        }

        @Override
        public boolean isObject() {
            return this.jsonNode.isObject();
        }

        @Override
        public Iterator<Node> arrayElements() {
            final Iterator<JsonNode> elements = this.jsonNode.elements();
            return new Iterator<Node>(this){
                final /* synthetic */ Jackson2Node this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean hasNext() {
                    return elements.hasNext();
                }

                @Override
                public Node next() {
                    return Jackson2NodeFactory.newNode((JsonNode)elements.next());
                }
            };
        }

        @Override
        public int size() {
            return this.jsonNode.size();
        }

        @Override
        public String asText() {
            return this.jsonNode.asText();
        }

        @Override
        public Node.NodeType getNodeType() {
            if (this.jsonNode.isObject()) {
                return Node.NodeType.OBJECT;
            }
            if (this.jsonNode.isArray()) {
                return Node.NodeType.ARRAY;
            }
            if (this.jsonNode.isTextual()) {
                return Node.NodeType.STRING;
            }
            if (this.jsonNode.isNumber()) {
                return Node.NodeType.NUMBER;
            }
            if (this.jsonNode.isBoolean()) {
                return Node.NodeType.BOOLEAN;
            }
            if (this.jsonNode.isNull()) {
                return Node.NodeType.NULL;
            }
            if (this.jsonNode.isBinary()) {
                return Node.NodeType.STRING;
            }
            throw new IllegalStateException("Unexpected node type " + String.valueOf(this.jsonNode));
        }

        @Override
        public BigDecimal decimalValue() {
            return this.jsonNode.decimalValue();
        }

        @Override
        public Boolean asBoolean() {
            return this.jsonNode.asBoolean();
        }

        public String toString() {
            return this.jsonNode.toString();
        }
    }
}

