/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core.internal;

import wiremock.net.javacrumbs.jsonunit.core.Configuration;
import wiremock.net.javacrumbs.jsonunit.core.ParametrizedMatcher;
import wiremock.net.javacrumbs.jsonunit.core.internal.Context;
import wiremock.net.javacrumbs.jsonunit.core.internal.Diff;
import wiremock.net.javacrumbs.jsonunit.core.internal.Node;
import wiremock.org.hamcrest.Matcher;
import wiremock.org.hamcrest.StringDescription;

class HamcrestHandler {
    private final Configuration configuration;
    private final DifferenceReporter valueDifferenceReporter;
    private final DifferenceReporter structureDifferenceReporter;

    HamcrestHandler(Configuration configuration, DifferenceReporter valueDifferenceReporter, DifferenceReporter structureDifferenceReporter) {
        this.configuration = configuration;
        this.valueDifferenceReporter = valueDifferenceReporter;
        this.structureDifferenceReporter = structureDifferenceReporter;
    }

    void matchHamcrestMatcher(Context context, Node actualNode, java.util.regex.Matcher patternMatcher, String matcherName) {
        Matcher<?> matcher = this.configuration.getMatcher(matcherName);
        if (matcher != null) {
            Object value;
            if (matcher instanceof ParametrizedMatcher) {
                ParametrizedMatcher parametrizedMatcher = (ParametrizedMatcher)((Object)matcher);
                parametrizedMatcher.setParameter(patternMatcher.group(2));
            }
            if (!matcher.matches(value = actualNode.getValue())) {
                StringDescription description = new StringDescription();
                description.appendText("Expected ");
                matcher.describeTo(description);
                description.appendText(" but ");
                matcher.describeMismatch(value, description);
                this.valueDifferenceReporter.differenceFound(context, "Matcher \"%s\" does not match value %s in node \"%s\". %s", matcherName, Diff.quoteTextValue(actualNode), context.actualPath(), description);
            }
        } else {
            this.structureDifferenceReporter.differenceFound(context, "Matcher \"%s\" not found.", matcherName);
        }
    }

    @FunctionalInterface
    static interface DifferenceReporter {
        public void differenceFound(Context var1, String var2, Object ... var3);
    }
}

