/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core.internal;

import java.util.ArrayList;
import java.util.List;
import wiremock.net.javacrumbs.jsonunit.core.internal.ClassUtils;
import wiremock.net.javacrumbs.jsonunit.core.internal.GsonNodeFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.Jackson2NodeFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.Jackson3NodeFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.JohnzonNodeFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.JsonOrgNodeFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.MoshiNodeFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.Node;
import wiremock.net.javacrumbs.jsonunit.core.internal.NodeFactory;
import wiremock.org.jspecify.annotations.Nullable;

record Converter(List<NodeFactory> factories) {
    static final String LIBRARIES_PROPERTY_NAME = "json-unit.libraries";
    private static final boolean jackson2Present = ClassUtils.isClassPresent("wiremock.com.fasterxml.jackson.databind.ObjectMapper") && ClassUtils.isClassPresent("wiremock.com.fasterxml.jackson.core.JsonGenerator");
    private static final boolean jackson3Present = ClassUtils.isClassPresent("tools.jackson.databind.ObjectMapper");
    private static final boolean gsonPresent = ClassUtils.isClassPresent("wiremock.com.google.gson.Gson");
    private static final boolean jsonOrgPresent = ClassUtils.isClassPresent("wiremock.org.json.JSONObject");
    private static final boolean moshiPresent = ClassUtils.isClassPresent("com.squareup.moshi.Moshi");
    private static final boolean johnzonPresent = ClassUtils.isClassPresent("wiremock.org.apache.johnzon.mapper.Mapper");

    Converter {
        if (factories.isEmpty()) {
            throw new IllegalStateException("List of factories can not be empty");
        }
    }

    static Converter createDefaultConverter() {
        String property = System.getProperty(LIBRARIES_PROPERTY_NAME);
        List<NodeFactory> factories = property != null && !property.trim().isEmpty() ? Converter.createFactoriesSpecifiedInProperty(property) : Converter.createDefaultFactories();
        if (factories.isEmpty()) {
            throw new IllegalStateException("Please add either json.org, Moshi, Jackson 2.x, Johnzon or Gson to the classpath");
        }
        return new Converter(factories);
    }

    private static List<NodeFactory> createFactoriesSpecifiedInProperty(String property) {
        ArrayList<NodeFactory> factories = new ArrayList<NodeFactory>();
        block16: for (String factoryName : property.toLowerCase().split(",")) {
            switch (factoryName = factoryName.trim()) {
                case "moshi": {
                    factories.add(new MoshiNodeFactory());
                    continue block16;
                }
                case "json.org": {
                    factories.add(new JsonOrgNodeFactory());
                    continue block16;
                }
                case "jackson2": {
                    factories.add(new Jackson2NodeFactory());
                    continue block16;
                }
                case "jackson3": {
                    factories.add(new Jackson3NodeFactory());
                    continue block16;
                }
                case "gson": {
                    factories.add(new GsonNodeFactory());
                    continue block16;
                }
                case "johnzon": {
                    factories.add(new JohnzonNodeFactory());
                    continue block16;
                }
                default: {
                    throw new IllegalArgumentException("'" + factoryName + "' library name not recognized.");
                }
            }
        }
        return factories;
    }

    private static List<NodeFactory> createDefaultFactories() {
        ArrayList<NodeFactory> factories = new ArrayList<NodeFactory>();
        if (moshiPresent) {
            factories.add(new MoshiNodeFactory());
        }
        if (johnzonPresent) {
            factories.add(new JohnzonNodeFactory());
        }
        if (jsonOrgPresent) {
            factories.add(new JsonOrgNodeFactory());
        }
        if (gsonPresent) {
            factories.add(new GsonNodeFactory());
        }
        if (jackson3Present) {
            factories.add(new Jackson3NodeFactory());
        }
        if (jackson2Present) {
            factories.add(new Jackson2NodeFactory());
        }
        return factories;
    }

    Node convertToNode(@Nullable Object source, String label, boolean lenient) {
        return this.findBestFactory(source).convertToNode(source, label, lenient);
    }

    private NodeFactory findBestFactory(@Nullable Object source) {
        if (this.factories.size() == 1) {
            return this.factories.get(0);
        }
        return this.factories.stream().filter(factory -> factory.isPreferredFor(source)).findFirst().orElseGet(() -> this.factories.get(this.factories.size() - 1));
    }
}

