/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.helper;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import wiremock.com.github.jknack.handlebars.Context;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.github.jknack.handlebars.TagType;
import wiremock.com.github.jknack.handlebars.Template;
import wiremock.org.apache.commons.lang3.Validate;

public class BlockHelper
implements Helper<Object> {
    public static final Helper<Object> INSTANCE = new BlockHelper();
    public static final String NAME = "block";

    @Override
    public Object apply(Object context, Options options) throws IOException {
        Validate.isTrue(context instanceof String, "found '%s', expected 'partial's name'", context);
        String path = (String)context;
        Template template = options.partial(path);
        if (template == null) {
            try {
                template = options.handlebars.compile(path);
            }
            catch (IOException ex) {
                Handlebars.debug(ex.getMessage());
                template = options.fn;
            }
        }
        TagType partialType = (TagType)((Object)options.data(Context.PARTIALS + "#" + String.valueOf(context) + "#type"));
        if (template == Template.EMPTY || partialType != null && partialType.inline()) {
            template = options.fn;
        }
        LinkedHashMap<String, Object> hash = new LinkedHashMap<String, Object>(options.hash);
        Map partialHash = (Map)options.data(Context.PARTIALS + "#" + String.valueOf(context) + "#hash");
        if (partialHash != null) {
            hash.putAll(partialHash);
        }
        CharSequence result = options.apply(template, options.context.data(hash));
        Boolean deletePartials = (Boolean)options.hash("delete-after-merge", options.handlebars.deletePartialAfterMerge());
        if (deletePartials.booleanValue()) {
            options.partial(path, null);
            options.data(Context.PARTIALS + "#" + String.valueOf(context) + "#hash", null);
        }
        return result;
    }
}

