/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.ethlo.time.internal;

import wiremock.com.ethlo.time.Duration;
import wiremock.com.ethlo.time.internal.DurationPartsConsumer;
import wiremock.com.ethlo.time.internal.fixed.ITUParser;

public class ItuDurationParser {
    public static final int NANOS_IN_SECOND = 1000000000;
    public static final char SEP_T = 'T';
    public static final char UNIT_WEEK = 'W';
    public static final char UNIT_DAY = 'D';
    public static final char UNIT_HOUR = 'H';
    public static final char UNIT_MINUTE = 'M';
    public static final char UNIT_SECOND = 'S';
    public static final char DOT = '.';
    public static final char DIGIT_ZERO = '0';
    public static final char DIGIT_NINE = '9';
    public static final char MINUS = '-';
    public static final char UNIT_UNDEFINED = '\u0000';

    public static Duration parse(String chars) {
        return ItuDurationParser.parse(chars, 0);
    }

    public static Duration parse(String text, int offset) {
        int availableLength = ITUParser.sanityCheckInputParams(text, offset);
        if (availableLength == 0) {
            DurationPartsConsumer.error("Duration cannot be empty", text, text.length() - 1);
        }
        boolean negative = false;
        int index = offset;
        if (text.charAt(offset) == '-') {
            negative = true;
            ++index;
        }
        DurationPartsConsumer handler = new DurationPartsConsumer(index, negative);
        int length = text.length();
        while (index < length) {
            index = ItuDurationParser.readUntilNonDigit(text, index, handler);
        }
        handler.validate(text, index);
        return handler.getResult();
    }

    private static int readUntilNonDigit(String text, int offset, DurationPartsConsumer consumer) {
        int index;
        long value = 0L;
        int startIndex = index = offset;
        while (index < text.length()) {
            char c = text.charAt(index);
            if (c < '0' || c > '9') {
                int length = index - startIndex;
                consumer.accept(text, index, length, c, value);
                value = 0L;
                startIndex = index + 1;
                break;
            }
            int digit = c - 48;
            value = Math.addExact(Math.multiplyExact(value, 10), (long)digit);
            ++index;
        }
        int length = index - startIndex;
        if (index - startIndex > 0) {
            consumer.accept(text, index, length, '\u0000', value);
        }
        return index + 1;
    }
}

