/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification.diff;

import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.verification.diff.Diff;
import com.github.tomakehurst.wiremock.verification.diff.DiffLine;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class JUnitStyleDiffRenderer {
    private static final Function<DiffLine<?>, Object> EXPECTED = line -> line.isForNonMatch() ? line.getPrintedPatternValue() : line.getActual();
    private static final Function<DiffLine<?>, Object> ACTUAL = DiffLine::getActual;

    public String render(Diff diff) {
        List<DiffLine<?>> lines = diff.getLines();
        String expected = lines.stream().map(EXPECTED).map(Object::toString).collect(Collectors.joining("\n"));
        String actual = lines.stream().map(ACTUAL).map(Object::toString).collect(Collectors.joining("\n"));
        return lines.isEmpty() ? "" : JUnitStyleDiffRenderer.junitStyleDiffMessage(expected, actual);
    }

    public static String junitStyleDiffMessage(Object expected, Object actual) {
        return String.format(" expected:<%n%s> but was:<%n%s>", Strings.normaliseLineBreaks(expected.toString()), Strings.normaliseLineBreaks(actual.toString()));
    }
}

