/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.xml.Xml;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.org.xmlunit.XMLUnitException;
import wiremock.org.xmlunit.builder.DiffBuilder;
import wiremock.org.xmlunit.builder.Input;
import wiremock.org.xmlunit.diff.Comparison;
import wiremock.org.xmlunit.diff.ComparisonControllers;
import wiremock.org.xmlunit.diff.ComparisonResult;
import wiremock.org.xmlunit.diff.ComparisonType;
import wiremock.org.xmlunit.diff.DefaultNodeMatcher;
import wiremock.org.xmlunit.diff.Diff;
import wiremock.org.xmlunit.diff.DifferenceEvaluator;
import wiremock.org.xmlunit.diff.DifferenceEvaluators;
import wiremock.org.xmlunit.placeholder.PlaceholderDifferenceEvaluator;

public class EqualToXmlPattern
extends StringValuePattern {
    private static final Set<ComparisonType> COUNTED_COMPARISONS = Set.of(ComparisonType.ELEMENT_TAG_NAME, ComparisonType.SCHEMA_LOCATION, ComparisonType.NO_NAMESPACE_SCHEMA_LOCATION, ComparisonType.NODE_TYPE, ComparisonType.NAMESPACE_URI, ComparisonType.TEXT_VALUE, ComparisonType.PROCESSING_INSTRUCTION_TARGET, ComparisonType.PROCESSING_INSTRUCTION_DATA, ComparisonType.ELEMENT_NUM_ATTRIBUTES, ComparisonType.ATTR_VALUE, ComparisonType.CHILD_NODELIST_LENGTH, ComparisonType.CHILD_LOOKUP, ComparisonType.ATTR_NAME_LOOKUP);
    private final DocumentBuilderFactory documentBuilderFactory;
    private final Boolean enablePlaceholders;
    private final String placeholderOpeningDelimiterRegex;
    private final String placeholderClosingDelimiterRegex;
    private final DifferenceEvaluator diffEvaluator;
    private final Set<ComparisonType> exemptedComparisons;
    private final Boolean ignoreOrderOfSameNode;
    private final NamespaceAwareness namespaceAwareness;
    private final Set<ComparisonType> countedComparisons;
    private final Document expectedXmlDoc;
    private static final DocumentBuilderFactory namespaceAware = EqualToXmlPattern.newDocumentBuilderFactory(true);
    private static final DocumentBuilderFactory namespaceUnaware = EqualToXmlPattern.newDocumentBuilderFactory(false);

    public EqualToXmlPattern(@JsonProperty(value="equalToXml") String expectedValue) {
        this(expectedValue, null, null, null, null, null, null);
    }

    public EqualToXmlPattern(@JsonProperty(value="equalToXml") String expectedValue, @JsonProperty(value="enablePlaceholders") Boolean enablePlaceholders, @JsonProperty(value="ignoreOrderOfSameNode") boolean ignoreOrderOfSameNode) {
        this(expectedValue, enablePlaceholders, null, null, null, ignoreOrderOfSameNode, null);
    }

    @JsonCreator
    public EqualToXmlPattern(@JsonProperty(value="equalToXml") String expectedValue, @JsonProperty(value="enablePlaceholders") Boolean enablePlaceholders, @JsonProperty(value="placeholderOpeningDelimiterRegex") String placeholderOpeningDelimiterRegex, @JsonProperty(value="placeholderClosingDelimiterRegex") String placeholderClosingDelimiterRegex, @JsonProperty(value="exemptedComparisons") Set<ComparisonType> exemptedComparisons, @JsonProperty(value="ignoreOrderOfSameNode") Boolean ignoreOrderOfSameNode, @JsonProperty(value="namespaceAwareness") NamespaceAwareness namespaceAwareness) {
        super(expectedValue);
        this.documentBuilderFactory = EqualToXmlPattern.getDocumentBuilderFactory(namespaceAwareness);
        this.expectedXmlDoc = Xml.read(expectedValue, this.documentBuilderFactory);
        this.enablePlaceholders = enablePlaceholders;
        this.placeholderOpeningDelimiterRegex = placeholderOpeningDelimiterRegex;
        this.placeholderClosingDelimiterRegex = placeholderClosingDelimiterRegex;
        this.exemptedComparisons = exemptedComparisons;
        this.ignoreOrderOfSameNode = ignoreOrderOfSameNode;
        this.namespaceAwareness = namespaceAwareness;
        HashSet<ComparisonType> comparisonsToExempt = new HashSet<ComparisonType>();
        if (exemptedComparisons != null) {
            comparisonsToExempt.addAll(exemptedComparisons);
        }
        this.countedComparisons = COUNTED_COMPARISONS.stream().filter(e -> !comparisonsToExempt.contains(e)).collect(Collectors.toSet());
        IgnoreUncountedDifferenceEvaluator baseDifferenceEvaluator = new IgnoreUncountedDifferenceEvaluator(comparisonsToExempt);
        this.diffEvaluator = enablePlaceholders != null && enablePlaceholders != false ? DifferenceEvaluators.chain(baseDifferenceEvaluator, new PlaceholderDifferenceEvaluator(placeholderOpeningDelimiterRegex, placeholderClosingDelimiterRegex)) : baseDifferenceEvaluator;
    }

    public String getEqualToXml() {
        return (String)this.expectedValue;
    }

    @Override
    public String getExpected() {
        try {
            return Xml.prettyPrint((String)this.getValue());
        }
        catch (Exception e) {
            return (String)this.getValue();
        }
    }

    public Boolean isEnablePlaceholders() {
        return this.enablePlaceholders;
    }

    public Boolean isIgnoreOrderOfSameNode() {
        return this.ignoreOrderOfSameNode;
    }

    public String getPlaceholderOpeningDelimiterRegex() {
        return this.placeholderOpeningDelimiterRegex;
    }

    public String getPlaceholderClosingDelimiterRegex() {
        return this.placeholderClosingDelimiterRegex;
    }

    public Set<ComparisonType> getExemptedComparisons() {
        return this.exemptedComparisons;
    }

    public NamespaceAwareness getNamespaceAwareness() {
        return this.namespaceAwareness;
    }

    @Override
    public MatchResult match(final String value) {
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                if (Strings.isNullOrEmpty(value)) {
                    return false;
                }
                try {
                    Diff diff;
                    DiffBuilder diffBuilder = DiffBuilder.compare(Input.from(EqualToXmlPattern.this.expectedXmlDoc)).withTest(value).withComparisonController(ComparisonControllers.StopWhenDifferent).ignoreWhitespace().withDifferenceEvaluator(EqualToXmlPattern.this.diffEvaluator).withNodeMatcher(new OrderInvariantNodeMatcher(EqualToXmlPattern.this.ignoreOrderOfSameNode)).withDocumentBuilderFactory(EqualToXmlPattern.this.documentBuilderFactory);
                    if (EqualToXmlPattern.this.namespaceAwareness == NamespaceAwareness.LEGACY) {
                        diffBuilder.ignoreComments();
                    }
                    return !(diff = diffBuilder.build()).hasDifferences();
                }
                catch (DOMException | XMLUnitException e) {
                    this.appendSubEvent(SubEvent.warning(e.getMessage()));
                    LocalNotifier.notifier().info("Failed to process XML. " + e.getMessage() + "\nExpected:\n" + (String)EqualToXmlPattern.this.expectedValue + "\n\nActual:\n" + value);
                    return false;
                }
            }

            @Override
            public double getDistance() {
                Diff diff;
                if (Strings.isNullOrEmpty(value)) {
                    return 1.0;
                }
                AtomicInteger totalComparisons = new AtomicInteger(0);
                AtomicInteger differences = new AtomicInteger(0);
                try {
                    DiffBuilder diffBuilder = DiffBuilder.compare(Input.from(EqualToXmlPattern.this.expectedValue)).withTest(value).ignoreWhitespace().withDifferenceEvaluator(EqualToXmlPattern.this.diffEvaluator).withComparisonListeners((comparison, outcome) -> {
                        if (EqualToXmlPattern.this.countedComparisons.contains((Object)comparison.getType()) && comparison.getControlDetails().getValue() != null) {
                            totalComparisons.incrementAndGet();
                            if (outcome == ComparisonResult.DIFFERENT) {
                                differences.incrementAndGet();
                            }
                        }
                    }).withDocumentBuilderFactory(EqualToXmlPattern.this.documentBuilderFactory);
                    if (EqualToXmlPattern.this.namespaceAwareness == NamespaceAwareness.LEGACY) {
                        diffBuilder.ignoreComments();
                    }
                    diff = diffBuilder.build();
                }
                catch (XMLUnitException e) {
                    LocalNotifier.notifier().info("Failed to process XML. " + e.getMessage() + "\nExpected:\n" + (String)EqualToXmlPattern.this.expectedValue + "\n\nActual:\n" + value);
                    return 1.0;
                }
                LocalNotifier.notifier().info(StreamSupport.stream(diff.getDifferences().spliterator(), false).map(Object::toString).collect(Collectors.joining("\n")));
                return differences.doubleValue() / totalComparisons.doubleValue();
            }
        };
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory(NamespaceAwareness namespaceAwareness) {
        if (namespaceAwareness == null || namespaceAwareness == NamespaceAwareness.STRICT) {
            return namespaceAware;
        }
        return namespaceUnaware;
    }

    private static DocumentBuilderFactory newDocumentBuilderFactory(boolean namespaceAware) {
        DocumentBuilderFactory factory = Xml.newDocumentBuilderFactory();
        try {
            factory.setFeature("http://apache.org/xml/features/include-comments", false);
            factory.setFeature("http://xml.org/sax/features/namespaces", namespaceAware);
        }
        catch (ParserConfigurationException e) {
            Exceptions.throwUnchecked(e);
        }
        return factory;
    }

    public EqualToXmlPattern exemptingComparisons(ComparisonType ... comparisons) {
        return new EqualToXmlPattern((String)this.expectedValue, this.enablePlaceholders, this.placeholderOpeningDelimiterRegex, this.placeholderClosingDelimiterRegex, new HashSet<ComparisonType>(Arrays.asList(comparisons)), this.ignoreOrderOfSameNode, this.namespaceAwareness);
    }

    public EqualToXmlPattern withNamespaceAwareness(NamespaceAwareness namespaceAwareness) {
        return new EqualToXmlPattern((String)this.expectedValue, this.enablePlaceholders, this.placeholderOpeningDelimiterRegex, this.placeholderClosingDelimiterRegex, this.exemptedComparisons, this.ignoreOrderOfSameNode, namespaceAwareness);
    }

    public static enum NamespaceAwareness {
        STRICT,
        LEGACY,
        NONE;

    }

    private static class IgnoreUncountedDifferenceEvaluator
    implements DifferenceEvaluator {
        private final Set<ComparisonType> finalCountedComparisons;

        public IgnoreUncountedDifferenceEvaluator(Set<ComparisonType> exemptedComparisons) {
            this.finalCountedComparisons = exemptedComparisons != null ? COUNTED_COMPARISONS.stream().filter(e -> !exemptedComparisons.contains(e)).collect(Collectors.toSet()) : COUNTED_COMPARISONS;
        }

        @Override
        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            if (this.finalCountedComparisons.contains((Object)comparison.getType()) && comparison.getControlDetails().getValue() != null) {
                return outcome;
            }
            return ComparisonResult.EQUAL;
        }
    }

    private static final class OrderInvariantNodeMatcher
    extends DefaultNodeMatcher {
        private static Boolean secondaryOrderByTextContent;

        public OrderInvariantNodeMatcher(Boolean secondaryOrderByTextContent) {
            OrderInvariantNodeMatcher.secondaryOrderByTextContent = secondaryOrderByTextContent;
        }

        @Override
        public Iterable<Map.Entry<Node, Node>> match(Iterable<Node> controlNodes, Iterable<Node> testNodes) {
            return super.match(OrderInvariantNodeMatcher.sort(controlNodes), OrderInvariantNodeMatcher.sort(testNodes));
        }

        private static Iterable<Node> sort(Iterable<Node> nodes) {
            return StreamSupport.stream(nodes.spliterator(), false).sorted(OrderInvariantNodeMatcher.getComparator()).collect(Collectors.toList());
        }

        private static Comparator<Node> getComparator() {
            if (Objects.nonNull(secondaryOrderByTextContent) && secondaryOrderByTextContent.booleanValue()) {
                return Comparator.comparing(Node::getLocalName).thenComparing(Node::getTextContent);
            }
            return Comparator.comparing(Node::getLocalName);
        }
    }
}

