/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty.servlet;

import java.io.IOException;
import wiremock.jakarta.servlet.Filter;
import wiremock.jakarta.servlet.FilterChain;
import wiremock.jakarta.servlet.FilterConfig;
import wiremock.jakarta.servlet.ServletContext;
import wiremock.jakarta.servlet.ServletException;
import wiremock.jakarta.servlet.ServletRequest;
import wiremock.jakarta.servlet.ServletResponse;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.jakarta.servlet.http.HttpServletResponse;

public class ContentTypeSettingFilter
implements Filter {
    private ServletContext context;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            String filePath = ((HttpServletRequest)request).getRequestURI();
            String contentType = this.context.getMimeType(filePath);
            if (contentType == null) {
                contentType = "application/json";
            }
            ((HttpServletResponse)response).setContentType(contentType);
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }
}

