/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty.proxy;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import wiremock.org.eclipse.jetty.server.Handler;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.server.ServerConnector;
import wiremock.org.eclipse.jetty.util.Callback;

public class HttpsProxyDetectingHandler
extends Handler.Abstract {
    public static final String IS_HTTPS_PROXY_REQUEST_ATTRIBUTE = "wiremock.isHttpsProxyRequest";
    private final ServerConnector mitmProxyConnector;

    public HttpsProxyDetectingHandler(ServerConnector mitmProxyConnector) {
        this.mitmProxyConnector = mitmProxyConnector;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        int httpsProxyPort = this.mitmProxyConnector.getLocalPort();
        int localPort = -1;
        SocketAddress local = request.getConnectionMetaData().getLocalSocketAddress();
        if (local instanceof InetSocketAddress) {
            localPort = ((InetSocketAddress)local).getPort();
        }
        if (localPort == httpsProxyPort) {
            request.setAttribute(IS_HTTPS_PROXY_REQUEST_ATTRIBUTE, true);
        }
        return false;
    }
}

