/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty.faults;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.core.FaultInjector;
import com.github.tomakehurst.wiremock.jetty.JettyHttpUtils;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import wiremock.jakarta.servlet.http.HttpServletResponse;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.eclipse.jetty.util.Callback;

public class JettyHttpsFaultInjector
implements FaultInjector {
    private static final byte[] GARBAGE = "lskdu018973t09sylgasjkfg1][]'./.sdlv".getBytes(StandardCharsets.UTF_8);
    private final HttpServletResponse response;
    private final EndPoint endpoint;
    private final Socket socket;

    public JettyHttpsFaultInjector(HttpServletResponse response, JettyHttpUtils utils) {
        this.response = response;
        Response jettyResponse = utils.unwrapResponse(response);
        this.endpoint = utils.unwrapEndPoint(jettyResponse);
        this.socket = utils.tlsSocket(jettyResponse);
    }

    @Override
    public void connectionResetByPeer() {
        try {
            this.socket.setSoLinger(true, 0);
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void emptyResponseAndCloseConnection() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void malformedResponseChunk() {
        try {
            this.response.setStatus(200);
            this.response.flushBuffer();
            this.writeGarbageThenCloseSocket();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void randomDataAndCloseConnection() {
        this.writeGarbageThenCloseSocket();
    }

    private void writeGarbageThenCloseSocket() {
        this.endpoint.write(new Callback(){

            @Override
            public void succeeded() {
                try {
                    JettyHttpsFaultInjector.this.socket.close();
                }
                catch (IOException e) {
                    LocalNotifier.notifier().error("Failed to close socket after Garbage write succeeded", e);
                }
            }

            @Override
            public void failed(Throwable x) {
                try {
                    JettyHttpsFaultInjector.this.socket.close();
                }
                catch (IOException e) {
                    LocalNotifier.notifier().error("Failed to close socket after Garbage write failed", e);
                }
            }
        }, BufferUtil.toBuffer(GARBAGE));
    }
}

