/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty;

import com.github.tomakehurst.wiremock.jetty.JettyHttpUtils;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import wiremock.jakarta.servlet.ServletResponse;
import wiremock.jakarta.servlet.http.HttpServletResponseWrapper;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletApiResponse;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.SelectableChannelEndPoint;
import wiremock.org.eclipse.jetty.io.ssl.SslConnection;
import wiremock.org.eclipse.jetty.server.Response;

public class Jetty12HttpUtils
implements JettyHttpUtils {
    @Override
    public Response unwrapResponse(ServletResponse httpServletResponse) {
        if (httpServletResponse instanceof HttpServletResponseWrapper) {
            ServletResponse unwrapped = ((HttpServletResponseWrapper)httpServletResponse).getResponse();
            return this.unwrapResponse(unwrapped);
        }
        return Jetty12HttpUtils.unwrap(httpServletResponse);
    }

    private static Response unwrap(ServletResponse wrapped) {
        if (wrapped instanceof Response) {
            return (Response)((Object)wrapped);
        }
        if (wrapped instanceof ServletApiResponse) {
            return ((ServletApiResponse)wrapped).getResponse();
        }
        throw new IllegalStateException("Cannot unwrap a" + Response.class.getName() + " from a " + wrapped.getClass().getName());
    }

    @Override
    public Socket socket(Response response) {
        SelectableChannelEndPoint ep = (SelectableChannelEndPoint)this.getEndpoint(response);
        return ((SocketChannel)ep.getChannel()).socket();
    }

    @Override
    public Socket tlsSocket(Response response) {
        SslConnection.SslEndPoint sslEndpoint = (SslConnection.SslEndPoint)this.getEndpoint(response);
        SelectableChannelEndPoint endpoint = (SelectableChannelEndPoint)sslEndpoint.getSslConnection().getEndPoint();
        return ((SocketChannel)endpoint.getChannel()).socket();
    }

    @Override
    public EndPoint unwrapEndPoint(Response jettyResponse) {
        return this.getEndpoint(jettyResponse);
    }

    private EndPoint getEndpoint(Response response) {
        return response.getRequest().getConnectionMetaData().getConnection().getEndPoint();
    }
}

