/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty;

import com.github.tomakehurst.wiremock.common.AsynchronousResponseSettings;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty.Jetty12HttpUtils;
import com.github.tomakehurst.wiremock.jetty.JettyHttpServer;
import com.github.tomakehurst.wiremock.jetty.JettyHttpUtils;
import com.github.tomakehurst.wiremock.jetty.JettySettings;
import com.github.tomakehurst.wiremock.jetty.JettyUtils;
import com.github.tomakehurst.wiremock.jetty.NotFoundHandler;
import com.github.tomakehurst.wiremock.jetty.WireMockHandlerDispatchingServlet;
import com.github.tomakehurst.wiremock.jetty.faults.JettyFaultInjectorFactory;
import com.github.tomakehurst.wiremock.jetty.proxy.HttpProxyDetectingHandler;
import com.github.tomakehurst.wiremock.jetty.proxy.HttpsProxyDetectingHandler;
import com.github.tomakehurst.wiremock.jetty.proxy.ManInTheMiddleSslConnectHandler;
import com.github.tomakehurst.wiremock.jetty.servlet.ContentTypeSettingFilter;
import com.github.tomakehurst.wiremock.jetty.servlet.NotMatchedServlet;
import com.github.tomakehurst.wiremock.jetty.servlet.TrailingSlashFilter;
import com.github.tomakehurst.wiremock.jetty.ssl.SslContexts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import wiremock.jakarta.servlet.DispatcherType;
import wiremock.org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import wiremock.org.eclipse.jetty.ee11.servlet.DefaultServlet;
import wiremock.org.eclipse.jetty.ee11.servlet.FilterHolder;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletContextRequest;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletHolder;
import wiremock.org.eclipse.jetty.ee11.servlets.CrossOriginFilter;
import wiremock.org.eclipse.jetty.http.HttpVersion;
import wiremock.org.eclipse.jetty.http.MimeTypes;
import wiremock.org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import wiremock.org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import wiremock.org.eclipse.jetty.io.NetworkTrafficListener;
import wiremock.org.eclipse.jetty.server.ConnectionFactory;
import wiremock.org.eclipse.jetty.server.Handler;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.server.HttpConnectionFactory;
import wiremock.org.eclipse.jetty.server.NetworkTrafficServerConnector;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.server.Server;
import wiremock.org.eclipse.jetty.server.ServerConnector;
import wiremock.org.eclipse.jetty.server.SslConnectionFactory;
import wiremock.org.eclipse.jetty.server.handler.gzip.GzipHandler;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.resource.Resource;
import wiremock.org.eclipse.jetty.util.resource.ResourceFactory;
import wiremock.org.eclipse.jetty.util.resource.Resources;
import wiremock.org.eclipse.jetty.util.ssl.SslContextFactory;
import wiremock.org.eclipse.jetty.util.thread.ThreadPool;

public class Jetty12HttpServer
extends JettyHttpServer {
    private ServerConnector mitmProxyConnector;

    public Jetty12HttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler, JettySettings jettySettings, ThreadPool threadPool) {
        super(options, adminRequestHandler, stubRequestHandler, jettySettings, threadPool);
    }

    @Override
    protected ServerConnector createHttpConnector(String bindAddress, int port, JettySettings jettySettings, NetworkTrafficListener listener) {
        HttpConfiguration httpConfig = JettyUtils.createHttpConfig(jettySettings);
        ConnectionFactory[] connectionFactories = (ConnectionFactory[])Stream.of(new HttpConnectionFactory(httpConfig), this.options.getHttp2PlainDisabled() ? null : new HTTP2CServerConnectionFactory(httpConfig)).filter(Objects::nonNull).toArray(ConnectionFactory[]::new);
        return JettyUtils.createServerConnector(this.jettyServer, bindAddress, jettySettings, port, listener, connectionFactories);
    }

    @Override
    protected ServerConnector createHttpsConnector(String bindAddress, HttpsSettings httpsSettings, JettySettings jettySettings, NetworkTrafficListener listener) {
        ConnectionFactory[] connectionFactories;
        HttpConfiguration httpConfig = JettyUtils.createHttpConfig(jettySettings);
        if (!this.options.getHttp2TlsDisabled()) {
            SslContextFactory.Server http2SslContextFactory = SslContexts.buildHttp2SslContextFactory(httpsSettings);
            HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
            HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpConfig);
            try {
                ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
                SslConnectionFactory ssl = new SslConnectionFactory(http2SslContextFactory, alpn.getProtocol());
                connectionFactories = new ConnectionFactory[]{ssl, alpn, h2, http};
            }
            catch (IllegalStateException e) {
                SslConnectionFactory ssl = new SslConnectionFactory(http2SslContextFactory, http.getProtocol());
                connectionFactories = new ConnectionFactory[]{ssl, http};
            }
        } else {
            SslContextFactory.Server sslContextFactory = SslContexts.buildHttp1_1SslContextFactory(httpsSettings);
            SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, "http/1.1");
            HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
            connectionFactories = new ConnectionFactory[]{ssl, http};
        }
        return JettyUtils.createServerConnector(this.jettyServer, bindAddress, jettySettings, httpsSettings.port(), listener, connectionFactories);
    }

    @Override
    protected void applyAdditionalServerConfiguration(Server jettyServer, Options options) {
        if (options.browserProxySettings().enabled()) {
            SslConnectionFactory ssl = new SslConnectionFactory(SslContexts.buildManInTheMiddleSslContextFactory(options.httpsSettings(), options.browserProxySettings(), options.notifier()), HttpVersion.HTTP_1_1.asString());
            HttpConfiguration httpConfig = JettyUtils.createHttpConfig(this.jettySettings);
            HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
            this.mitmProxyConnector = new NetworkTrafficServerConnector(jettyServer, null, null, null, 2, 2, ssl, http);
            this.mitmProxyConnector.setPort(0);
            this.mitmProxyConnector.setShutdownIdleTimeout(this.jettySettings.getShutdownIdleTimeout().orElse(100L));
            jettyServer.addConnector(this.mitmProxyConnector);
        }
    }

    @Override
    protected Handler createHandler(final Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        Notifier notifier = options.notifier();
        ServletContextHandler adminContext = this.addAdminContext(adminRequestHandler, notifier);
        ServletContextHandler mockServiceContext = this.addMockServiceContext(adminContext, stubRequestHandler, options.filesRoot().child("__files"), options.getAsynchronousResponseSettings(), options.getChunkedEncodingPolicy(), options.getStubCorsEnabled(), options.browserProxySettings().enabled(), notifier);
        ArrayList<Handler> handlers = new ArrayList<Handler>(Arrays.asList(this.extensionHandlers()));
        handlers.add(adminContext);
        Handler.Abstract asyncTimeoutSettingHandler = new Handler.Abstract(){

            @Override
            public boolean handle(Request request, Response response, Callback callback) {
                if (request instanceof ServletContextRequest) {
                    ServletContextRequest r = (ServletContextRequest)request;
                    r.getState().setTimeout(options.timeout());
                }
                return false;
            }
        };
        handlers.add(asyncTimeoutSettingHandler);
        if (options.getGzipDisabled()) {
            handlers.add(mockServiceContext);
        } else {
            this.addGZipHandler(mockServiceContext, handlers);
        }
        if (options.browserProxySettings().enabled()) {
            handlers.add(0, new HttpProxyDetectingHandler(this.httpConnector));
            handlers.add(0, new HttpsProxyDetectingHandler(this.mitmProxyConnector));
            handlers.add(0, new ManInTheMiddleSslConnectHandler(this.mitmProxyConnector));
        }
        return new Handler.Sequence(handlers);
    }

    protected void decorateAdminServiceContextBeforeConfig(ServletContextHandler adminServiceContext) {
    }

    protected void decorateAdminServiceContextAfterConfig(ServletContextHandler adminServiceContext) {
    }

    private void addCorsFilter(ServletContextHandler context) {
        context.addFilter(this.buildCorsFilter(), "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private ServletContextHandler addAdminContext(AdminRequestHandler adminRequestHandler, Notifier notifier) {
        ServletContextHandler adminContext = new ServletContextHandler();
        adminContext.setServer(this.jettyServer);
        adminContext.setContextPath("/__admin");
        this.decorateAdminServiceContextBeforeConfig(adminContext);
        adminContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.maxCacheSize", "0");
        Resource assetsResource = ResourceFactory.of(adminContext).newClassLoaderResource("assets");
        if (Resources.isReadable(assetsResource)) {
            adminContext.setBaseResource(assetsResource);
        }
        adminContext.setWelcomeFiles(new String[]{"index.html", "index.jsp"});
        adminContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        ServletHolder swaggerUiServletHolder = adminContext.addServlet(DefaultServlet.class, "/swagger-ui/*");
        swaggerUiServletHolder.setInitParameter("baseResource", "swagger-ui");
        swaggerUiServletHolder.setAsyncSupported(false);
        ServletHolder recorderServletHolder = adminContext.addServlet(DefaultServlet.class, "/recorder/*");
        recorderServletHolder.setInitParameter("baseResource", "recorder");
        ServletHolder servletHolder = adminContext.addServlet(WireMockHandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", AdminRequestHandler.class.getName());
        adminContext.setAttribute(AdminRequestHandler.class.getName(), adminRequestHandler);
        adminContext.setAttribute("Notifier", notifier);
        servletHolder.getRegistration().setMultipartConfig(this.buildMultipartRequestConfigurer().build());
        adminContext.addServlet(NotMatchedServlet.class, "/not-matched");
        this.addCorsFilter(adminContext);
        this.decorateAdminServiceContextAfterConfig(adminContext);
        return adminContext;
    }

    private ServletContextHandler addMockServiceContext(ServletContextHandler adminContext, StubRequestHandler stubRequestHandler, FileSource fileSource, AsynchronousResponseSettings asynchronousResponseSettings, Options.ChunkedEncodingPolicy chunkedEncodingPolicy, boolean stubCorsEnabled, boolean browserProxyingEnabled, Notifier notifier) {
        Resource fileSourceResource;
        ServletContextHandler mockServiceContext = new ServletContextHandler();
        mockServiceContext.setServer(this.jettyServer);
        mockServiceContext.setContextPath("/");
        String fileSourcePath = fileSource.getPath();
        if (!fileSourcePath.isEmpty() && Resources.isReadable(fileSourceResource = ResourceFactory.of(mockServiceContext).newResource(fileSourcePath))) {
            mockServiceContext.setBaseResource(fileSourceResource);
        }
        this.decorateMockServiceContextBeforeConfig(mockServiceContext);
        mockServiceContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.maxCacheSize", "0");
        mockServiceContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        mockServiceContext.addServlet(DefaultServlet.class, FILES_URL_MATCH);
        Jetty12HttpUtils utils = new Jetty12HttpUtils();
        mockServiceContext.setAttribute(JettyHttpUtils.class.getName(), utils);
        mockServiceContext.setAttribute(JettyFaultInjectorFactory.class.getName(), new JettyFaultInjectorFactory(utils));
        mockServiceContext.setAttribute(StubRequestHandler.class.getName(), stubRequestHandler);
        mockServiceContext.setAttribute("Notifier", notifier);
        mockServiceContext.setAttribute(Options.ChunkedEncodingPolicy.class.getName(), (Object)chunkedEncodingPolicy);
        mockServiceContext.setAttribute("browserProxyingEnabled", browserProxyingEnabled);
        ServletHolder servletHolder = mockServiceContext.addServlet(WireMockHandlerDispatchingServlet.class, "/");
        servletHolder.setInitOrder(1);
        servletHolder.setInitParameter("RequestHandlerClass", StubRequestHandler.class.getName());
        servletHolder.setInitParameter("FaultHandlerFactoryClass", JettyFaultInjectorFactory.class.getName());
        servletHolder.setInitParameter("shouldForwardToFilesContext", "true");
        if (asynchronousResponseSettings.isEnabled()) {
            this.scheduledExecutorService = Executors.newScheduledThreadPool(asynchronousResponseSettings.getThreads());
            mockServiceContext.setAttribute(WireMockHandlerDispatchingServlet.ASYNCHRONOUS_RESPONSE_EXECUTOR, this.scheduledExecutorService);
        }
        servletHolder.getRegistration().setMultipartConfig(this.buildMultipartRequestConfigurer().build());
        MimeTypes.Mutable mimeTypes = mockServiceContext.getMimeTypes();
        mimeTypes.addMimeMapping("*", "application/json");
        mimeTypes.addMimeMapping("json", "application/json");
        mimeTypes.addMimeMapping("html", "text/html");
        mimeTypes.addMimeMapping("xml", "application/xml");
        mimeTypes.addMimeMapping("txt", "text/plain");
        Stream.of("text/plain", "text/xml", "text/html", "application/xhtml+xml").forEach(mt -> mimeTypes.addInferred((String)mt, null));
        mockServiceContext.setWelcomeFiles(new String[]{"index.json", "index.html", "index.xml", "index.txt"});
        NotFoundHandler errorHandler = new NotFoundHandler(adminContext);
        mockServiceContext.setErrorHandler(errorHandler);
        mockServiceContext.addFilter(ContentTypeSettingFilter.class, FILES_URL_MATCH, EnumSet.of(DispatcherType.FORWARD));
        mockServiceContext.addFilter(TrailingSlashFilter.class, FILES_URL_MATCH, EnumSet.allOf(DispatcherType.class));
        if (stubCorsEnabled) {
            this.addCorsFilter(mockServiceContext);
        }
        this.decorateMockServiceContextAfterConfig(mockServiceContext);
        return mockServiceContext;
    }

    protected void decorateMockServiceContextBeforeConfig(ServletContextHandler mockServiceContext) {
    }

    protected void decorateMockServiceContextAfterConfig(ServletContextHandler mockServiceContext) {
    }

    private void addGZipHandler(ServletContextHandler mockServiceContext, List<Handler> handlers) {
        try {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.addIncludedMethods(GZIPPABLE_METHODS);
            gzipHandler.setHandler(mockServiceContext);
            gzipHandler.setVary(null);
            handlers.add(gzipHandler);
        }
        catch (Exception e) {
            Exceptions.throwUnchecked(e);
        }
    }

    private FilterHolder buildCorsFilter() {
        FilterHolder filterHolder = new FilterHolder(CrossOriginFilter.class);
        filterHolder.setInitParameters(Map.of("chainPreflight", "false", "allowedOrigins", "*", "allowedHeaders", "*", "allowedMethods", "OPTIONS,GET,POST,PUT,PATCH,DELETE"));
        return filterHolder;
    }
}

