/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.client.apache5;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.core.Version;
import com.github.tomakehurst.wiremock.http.client.apache5.NetworkAddressRulesAdheringDnsResolver;
import com.github.tomakehurst.wiremock.http.client.apache5.TrustSelfSignedStrategy;
import com.github.tomakehurst.wiremock.http.ssl.HostVerifyingSSLSocketFactory;
import com.github.tomakehurst.wiremock.http.ssl.SSLContextBuilder;
import com.github.tomakehurst.wiremock.http.ssl.TrustEverythingStrategy;
import com.github.tomakehurst.wiremock.http.ssl.TrustSpecificHostsStrategy;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import wiremock.org.apache.hc.client5.http.auth.AuthScope;
import wiremock.org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import wiremock.org.apache.hc.client5.http.config.RequestConfig;
import wiremock.org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import wiremock.org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import wiremock.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import wiremock.org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import wiremock.org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import wiremock.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import wiremock.org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import wiremock.org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import wiremock.org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import wiremock.org.apache.hc.core5.http.HttpHost;
import wiremock.org.apache.hc.core5.http.config.CharCodingConfig;
import wiremock.org.apache.hc.core5.util.TextUtils;
import wiremock.org.apache.hc.core5.util.TimeValue;
import wiremock.org.apache.hc.core5.util.Timeout;

class StaticApacheHttpClientFactory {
    StaticApacheHttpClientFactory() {
    }

    static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds, ProxySettings proxySettings, KeyStoreSettings trustStoreSettings, boolean trustAllCertificates, List<String> trustedHosts, boolean useSystemProperties, NetworkAddressRules networkAddressRules, boolean disableConnectionReuse, String userAgent) {
        NetworkAddressRulesAdheringDnsResolver dnsResolver = new NetworkAddressRulesAdheringDnsResolver(networkAddressRules);
        HttpClientBuilder builder = HttpClientBuilder.create().disableAuthCaching().disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().disableContentCompression().setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds(timeoutMilliseconds)).setProtocolUpgradeEnabled(false).build());
        Object effectiveUserAgent = userAgent != null ? userAgent : "WireMock " + Version.getCurrentVersion();
        builder.setUserAgent((String)effectiveUserAgent);
        if (disableConnectionReuse) {
            builder.setConnectionReuseStrategy((request, response, context) -> false).setKeepAliveStrategy((response, context) -> TimeValue.ZERO_MILLISECONDS);
        }
        if (useSystemProperties) {
            builder.useSystemProperties();
        }
        if (proxySettings != ProxySettings.NO_PROXY) {
            HttpHost proxyHost = new HttpHost(proxySettings.host(), proxySettings.port());
            builder.setProxy(proxyHost);
            if (Strings.isNotEmpty(proxySettings.getUsername()) && Strings.isNotEmpty(proxySettings.getPassword())) {
                builder.setProxyAuthenticationStrategy(new DefaultAuthenticationStrategy());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxySettings.host(), proxySettings.port()), new UsernamePasswordCredentials(proxySettings.getUsername(), proxySettings.getPassword().toCharArray()));
                builder.setDefaultCredentialsProvider(credentialsProvider);
            }
        }
        SSLContext sslContext = StaticApacheHttpClientFactory.buildSslContext(trustStoreSettings, trustAllCertificates, trustedHosts);
        LayeredConnectionSocketFactory sslSocketFactory = StaticApacheHttpClientFactory.buildSslConnectionSocketFactory(sslContext);
        builder.setConnectionManager(PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory(sslSocketFactory).setDnsResolver(dnsResolver).setMaxConnPerRoute(maxConnections).setMaxConnTotal(maxConnections).setValidateAfterInactivity(TimeValue.ofSeconds(5L)).setConnectionFactory(new ManagedHttpClientConnectionFactory(null, CharCodingConfig.custom().setCharset(StandardCharsets.UTF_8).build(), null)).build());
        return builder.build();
    }

    private static LayeredConnectionSocketFactory buildSslConnectionSocketFactory(SSLContext sslContext) {
        String[] supportedProtocols = StaticApacheHttpClientFactory.split(System.getProperty("https.protocols"));
        String[] supportedCipherSuites = StaticApacheHttpClientFactory.split(System.getProperty("https.cipherSuites"));
        return new SSLConnectionSocketFactory(new HostVerifyingSSLSocketFactory(sslContext.getSocketFactory()), supportedProtocols, supportedCipherSuites, (HostnameVerifier)new NoopHostnameVerifier());
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank(s)) {
            return null;
        }
        return s.split(" *, *");
    }

    private static SSLContext buildSslContext(KeyStoreSettings trustStoreSettings, boolean trustAllCertificates, List<String> trustedHosts) {
        if (trustStoreSettings != KeyStoreSettings.NO_STORE) {
            return StaticApacheHttpClientFactory.buildSSLContextWithTrustStore(trustStoreSettings, trustAllCertificates, trustedHosts);
        }
        if (trustAllCertificates) {
            return StaticApacheHttpClientFactory.buildAllowAnythingSSLContext();
        }
        try {
            return SSLContextBuilder.create().loadTrustMaterial(new TrustSpecificHostsStrategy(trustedHosts)).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            return (SSLContext)Exceptions.throwUnchecked(e, null);
        }
    }

    private static SSLContext buildSSLContextWithTrustStore(KeyStoreSettings trustStoreSettings, boolean trustSelfSignedCertificates, List<String> trustedHosts) {
        try {
            KeyStore trustStore = trustStoreSettings.loadStore();
            SSLContextBuilder sslContextBuilder = SSLContextBuilder.create().loadKeyMaterial(trustStore, trustStoreSettings.password().toCharArray());
            if (trustSelfSignedCertificates) {
                sslContextBuilder.loadTrustMaterial(new TrustSelfSignedStrategy());
            } else if (StaticApacheHttpClientFactory.containsCertificate(trustStore)) {
                sslContextBuilder.loadTrustMaterial(trustStore, new TrustSpecificHostsStrategy(trustedHosts));
            } else {
                sslContextBuilder.loadTrustMaterial(new TrustSpecificHostsStrategy(trustedHosts));
            }
            return sslContextBuilder.build();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, SSLContext.class);
        }
    }

    private static boolean containsCertificate(KeyStore trustStore) throws KeyStoreException {
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            try {
                if (!(trustStore.getEntry(alias, null) instanceof KeyStore.TrustedCertificateEntry)) continue;
                return true;
            }
            catch (NoSuchAlgorithmException | UnrecoverableEntryException generalSecurityException) {
            }
        }
        return false;
    }

    private static SSLContext buildAllowAnythingSSLContext() {
        try {
            return SSLContextBuilder.create().loadTrustMaterial(new TrustEverythingStrategy()).build();
        }
        catch (Exception e) {
            return (SSLContext)Exceptions.throwUnchecked(e, null);
        }
    }
}

