/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.client.apache5;

import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.client.HttpClient;
import com.github.tomakehurst.wiremock.http.client.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.client.apache5.ApacheBackedHttpClient;
import com.github.tomakehurst.wiremock.http.client.apache5.StaticApacheHttpClientFactory;
import java.util.Collections;
import java.util.List;
import wiremock.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;

public class ApacheHttpClientFactory
implements HttpClientFactory {
    @Override
    public HttpClient buildHttpClient(Options options, boolean trustAllCertificates, List<String> trustedHosts, boolean useSystemProperties) {
        CloseableHttpClient apacheClient = ApacheHttpClientFactory.createClient(options.getMaxHttpClientConnections(), options.proxyTimeout(), options.proxyVia(), options.httpsSettings().trustStore(), trustAllCertificates, trustedHosts, useSystemProperties, options.getProxyTargetRules(), options.getDisableConnectionReuse(), null);
        return new ApacheBackedHttpClient(apacheClient, options.shouldPreserveUserAgentProxyHeader());
    }

    public static CloseableHttpClient createClient() {
        return ApacheHttpClientFactory.createClient(30000);
    }

    public static CloseableHttpClient createClient(int timeoutMilliseconds) {
        return ApacheHttpClientFactory.createClient(50, timeoutMilliseconds, ProxySettings.NO_PROXY, KeyStoreSettings.NO_STORE, true, Collections.emptyList(), true, NetworkAddressRules.ALLOW_ALL, false, null);
    }

    public static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds, ProxySettings proxySettings, KeyStoreSettings trustStoreSettings, boolean trustAllCertificates, List<String> trustedHosts, boolean useSystemProperties, NetworkAddressRules networkAddressRules, boolean disableConnectionReuse, String userAgent) {
        return StaticApacheHttpClientFactory.createClient(maxConnections, timeoutMilliseconds, proxySettings, trustStoreSettings, trustAllCertificates, trustedHosts, useSystemProperties, networkAddressRules, disableConnectionReuse, userAgent);
    }
}

