/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.MultiRequestMethodPattern;
import java.io.IOException;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import wiremock.com.fasterxml.jackson.core.JacksonException;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.databind.DeserializationContext;
import wiremock.com.fasterxml.jackson.databind.JsonDeserializer;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.ArrayNode;

public class RequestMethodJsonDeserializer
extends JsonDeserializer<RequestMethod> {
    @Override
    public RequestMethod deserialize(JsonParser parser, DeserializationContext context) throws IOException, JacksonException {
        RequestMethod requestMethod;
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        if (rootNode.has("oneOf")) {
            ArrayNode itemsNode = (ArrayNode)rootNode.get("oneOf");
            Set<RequestMethod> methods = RequestMethodJsonDeserializer.toRequestMethodSet(itemsNode);
            requestMethod = new MultiRequestMethodPattern.IsOneOf(methods);
        } else if (rootNode.has("noneOf")) {
            ArrayNode itemsNode = (ArrayNode)rootNode.get("noneOf");
            Set<RequestMethod> methods = RequestMethodJsonDeserializer.toRequestMethodSet(itemsNode);
            requestMethod = new MultiRequestMethodPattern.IsNoneOf(methods);
        } else {
            requestMethod = RequestMethod.fromString(rootNode.asText());
        }
        return requestMethod;
    }

    private static Set<RequestMethod> toRequestMethodSet(ArrayNode itemsNode) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(itemsNode.elements(), 16), false).map(JsonNode::asText).map(RequestMethod::fromString).collect(Collectors.toSet());
    }
}

