/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension;

import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Extensions;
import com.github.tomakehurst.wiremock.http.DefaultFactory;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class StaticExtensionLoader<T extends Extension> {
    private final Class<T> type;
    private T specificInstance = null;
    private Collection<T> extensions = List.of();
    private Supplier<Stream<T>> serviceLoader;

    public StaticExtensionLoader(Class<T> type) {
        this.type = type;
        this.serviceLoader = StaticExtensionLoader.systemServiceLoader(type);
    }

    public T load() {
        if (this.specificInstance != null) {
            return this.specificInstance;
        }
        if (!this.extensions.isEmpty()) {
            return this.pickMostAppropriateFrom(this.extensions.stream());
        }
        return this.pickMostAppropriateFrom(this.serviceLoader.get());
    }

    public StaticExtensionLoader<T> setSpecificInstance(T specificInstance) {
        this.specificInstance = specificInstance;
        return this;
    }

    public StaticExtensionLoader<T> setExtensions(List<T> extensions) {
        this.extensions = extensions;
        return this;
    }

    public StaticExtensionLoader<T> setExtensions(Extensions extensions) {
        this.extensions = extensions.ofType(this.type).values();
        return this;
    }

    public StaticExtensionLoader<T> setServiceLoader(Supplier<Stream<T>> serviceLoader) {
        this.serviceLoader = serviceLoader;
        return this;
    }

    private T pickMostAppropriateFrom(Stream<T> candidates) {
        return (T)((Extension)candidates.min(this.defaultFactoryLast()).orElseThrow(this::couldNotFindSuitableImplementationException));
    }

    private Comparator<Object> defaultFactoryLast() {
        return (o1, o2) -> {
            boolean o1IsDefault = o1 instanceof DefaultFactory;
            boolean o2IsDefault = o2 instanceof DefaultFactory;
            if (o1IsDefault == o2IsDefault) {
                return 0;
            }
            if (o1IsDefault) {
                return 1;
            }
            return -1;
        };
    }

    private FatalStartupException couldNotFindSuitableImplementationException() {
        return new FatalStartupException("No suitable " + this.type.getSimpleName() + " was found. Please ensure that the classpath includes a WireMock extension that provides an " + this.type.getSimpleName() + " implementation. See https://wiremock.org/docs/extending-wiremock/ for more information.");
    }

    private static <T extends Extension> Supplier<Stream<T>> systemServiceLoader(Class<T> type) {
        return () -> ServiceLoader.load(Extension.class).stream().filter(extension -> type.isAssignableFrom(extension.type())).map(e -> (Extension)e.get());
    }
}

