/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.ParsePosition;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import wiremock.com.google.common.collect.ImmutableListMultimap;
import wiremock.com.google.common.collect.Maps;

public class Urls {
    private Urls() {
    }

    public static Map<String, QueryParameter> splitQueryFromUrl(String url) {
        String queryPart = url.contains("?") && !url.endsWith("?") ? url.substring(url.indexOf(63) + 1) : null;
        return Urls.splitQuery(queryPart);
    }

    public static Map<String, QueryParameter> splitQuery(URI uri) {
        if (uri == null) {
            return Collections.emptyMap();
        }
        return Urls.splitQuery(uri.getRawQuery());
    }

    public static Map<String, QueryParameter> splitQuery(String query) {
        if (query == null) {
            return Collections.emptyMap();
        }
        List pairs = Arrays.stream(query.split("&")).collect(Collectors.toList());
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (String queryElement : pairs) {
            int firstEqualsIndex = queryElement.indexOf(61);
            if (firstEqualsIndex == -1) {
                builder.putAll((Object)Urls.decode(queryElement), new String[]{""});
                continue;
            }
            String key2 = Urls.decode(queryElement.substring(0, firstEqualsIndex));
            String value = Urls.decode(queryElement.substring(firstEqualsIndex + 1));
            builder.putAll((Object)key2, new String[]{value});
        }
        return Maps.transformEntries(builder.build().asMap(), (key, values) -> new QueryParameter((String)key, (List<String>)new ArrayList<String>((Collection<String>)values)));
    }

    public static String getPath(String url) {
        return url.contains("?") ? url.substring(0, url.indexOf("?")) : url;
    }

    public static String getPathAndQuery(String url) {
        return Urls.isAbsolute(url) ? url.substring(Strings.ordinalIndexOf(url, "/", 3)) : url;
    }

    private static boolean isAbsolute(String url) {
        return url.matches("^https?:\\/\\/.*");
    }

    public static List<String> getPathSegments(String path) {
        return List.of(path.split("/"));
    }

    public static String urlToPathParts(URI uri) {
        List uriPathNodes = Arrays.stream(uri.getPath().split("/")).filter(s -> !s.isEmpty()).collect(Collectors.toUnmodifiableList());
        int nodeCount = uriPathNodes.size();
        return nodeCount > 0 ? String.join((CharSequence)"-", uriPathNodes) : "";
    }

    public static String decode(String encoded) {
        if (!Urls.isISOOffsetDateTime(encoded)) {
            return URLDecoder.decode(encoded, StandardCharsets.UTF_8);
        }
        return encoded;
    }

    private static boolean isISOOffsetDateTime(String encoded) {
        ParsePosition pos = new ParsePosition(0);
        TemporalAccessor temporalAccessor = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parseUnresolved(encoded, pos);
        if (temporalAccessor == null || pos.getIndex() != encoded.length()) {
            return false;
        }
        try {
            DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(encoded);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    public static URL safelyCreateURL(String url) {
        try {
            return new URL(Urls.clean(url));
        }
        catch (MalformedURLException e) {
            return Exceptions.throwUnchecked(e, URL.class);
        }
    }

    private static String clean(String url) {
        return url.matches(".*:[0-9]+null$") ? url.substring(0, url.length() - 4) : url;
    }

    public static int getPort(URL url) {
        if (url.getPort() == -1) {
            return url.getProtocol().equals("https") ? 443 : 80;
        }
        return url.getPort();
    }
}

