/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.ScenarioMappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Metadata;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.PostServeActionDefinition;
import com.github.tomakehurst.wiremock.extension.ServeEventListener;
import com.github.tomakehurst.wiremock.extension.ServeEventListenerDefinition;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.CustomMatcherDefinition;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePatternBuilder;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

class BasicMappingBuilder
implements ScenarioMappingBuilder {
    private final RequestPatternBuilder requestPatternBuilder;
    private ResponseDefinitionBuilder responseDefBuilder;
    private Integer priority;
    private String scenarioName;
    private String requiredScenarioState;
    private String newScenarioState;
    private UUID id = UUID.randomUUID();
    private String name;
    private Boolean isPersistent = null;
    private List<PostServeActionDefinition> postServeActions = new ArrayList<PostServeActionDefinition>();
    private List<ServeEventListenerDefinition> serveEventListeners = new ArrayList<ServeEventListenerDefinition>();
    private Metadata metadata;

    BasicMappingBuilder(RequestMethod method, UrlPattern urlPattern) {
        this.requestPatternBuilder = new RequestPatternBuilder(method, urlPattern);
    }

    BasicMappingBuilder(ValueMatcher<Request> requestMatcher) {
        this.requestPatternBuilder = new RequestPatternBuilder(requestMatcher);
    }

    BasicMappingBuilder(String customRequestMatcherName, Parameters parameters) {
        this.requestPatternBuilder = new RequestPatternBuilder(customRequestMatcherName, parameters);
    }

    @Override
    public BasicMappingBuilder willReturn(ResponseDefinitionBuilder responseDefBuilder) {
        this.responseDefBuilder = responseDefBuilder;
        return this;
    }

    @Override
    public BasicMappingBuilder atPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public MappingBuilder withScheme(String scheme) {
        this.requestPatternBuilder.withScheme(scheme);
        return this;
    }

    @Override
    public MappingBuilder withHost(StringValuePattern hostPattern) {
        this.requestPatternBuilder.withHost(hostPattern);
        return this;
    }

    @Override
    public MappingBuilder withPort(int port) {
        this.requestPatternBuilder.withPort(port);
        return this;
    }

    @Override
    public MappingBuilder withClientIp(StringValuePattern clientIpPattern) {
        this.requestPatternBuilder.withClientIp(clientIpPattern);
        return this;
    }

    @Override
    public BasicMappingBuilder withHeader(String key, StringValuePattern headerPattern) {
        this.requestPatternBuilder.withHeader(key, headerPattern);
        return this;
    }

    @Override
    public BasicMappingBuilder withHeader(String key, MultiValuePattern headerPattern) {
        this.requestPatternBuilder.withHeader(key, headerPattern);
        return this;
    }

    @Override
    public BasicMappingBuilder withCookie(String name, StringValuePattern cookieValuePattern) {
        this.requestPatternBuilder.withCookie(name, cookieValuePattern);
        return this;
    }

    @Override
    public BasicMappingBuilder withQueryParam(String key, StringValuePattern queryParamPattern) {
        this.requestPatternBuilder.withQueryParam(key, queryParamPattern);
        return this;
    }

    @Override
    public BasicMappingBuilder withQueryParam(String key, MultiValuePattern queryParamPattern) {
        this.requestPatternBuilder.withQueryParam(key, queryParamPattern);
        return this;
    }

    @Override
    public ScenarioMappingBuilder withFormParam(String key, StringValuePattern formParamPattern) {
        this.requestPatternBuilder.withFormParam(key, formParamPattern);
        return this;
    }

    @Override
    public ScenarioMappingBuilder withFormParam(String key, MultiValuePattern formParamPattern) {
        this.requestPatternBuilder.withFormParam(key, formParamPattern);
        return this;
    }

    @Override
    public BasicMappingBuilder withFormParams(Map<String, MultiValuePattern> formParams) {
        for (Map.Entry<String, MultiValuePattern> formParam : formParams.entrySet()) {
            this.requestPatternBuilder.withFormParam(formParam.getKey(), formParam.getValue());
        }
        return this;
    }

    @Override
    public BasicMappingBuilder withPathParam(String key, StringValuePattern pathParamPattern) {
        this.requestPatternBuilder.withPathParam(key, pathParamPattern);
        return this;
    }

    @Override
    public BasicMappingBuilder withQueryParams(Map<String, StringValuePattern> queryParams) {
        for (Map.Entry<String, StringValuePattern> queryParam : queryParams.entrySet()) {
            this.requestPatternBuilder.withQueryParam(queryParam.getKey(), queryParam.getValue());
        }
        return this;
    }

    @Override
    public BasicMappingBuilder withRequestBody(ContentPattern<?> bodyPattern) {
        this.requestPatternBuilder.withRequestBody(bodyPattern);
        return this;
    }

    @Override
    public BasicMappingBuilder withMultipartRequestBody(MultipartValuePatternBuilder multipartPatternBuilder) {
        this.requestPatternBuilder.withRequestBodyPart(multipartPatternBuilder.build());
        return this;
    }

    @Override
    public BasicMappingBuilder inScenario(String scenarioName) {
        ParameterUtils.checkParameter(scenarioName != null, "Scenario name must not be null");
        this.scenarioName = scenarioName;
        return this;
    }

    @Override
    public BasicMappingBuilder whenScenarioStateIs(String stateName) {
        this.requiredScenarioState = stateName;
        return this;
    }

    @Override
    public BasicMappingBuilder willSetStateTo(String stateName) {
        this.newScenarioState = stateName;
        return this;
    }

    @Override
    public BasicMappingBuilder withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    public BasicMappingBuilder withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ScenarioMappingBuilder persistent() {
        this.isPersistent = true;
        return this;
    }

    @Override
    public ScenarioMappingBuilder persistent(boolean persistent) {
        this.isPersistent = persistent;
        return this;
    }

    @Override
    public BasicMappingBuilder withBasicAuth(String username, String password) {
        this.requestPatternBuilder.withBasicAuth(new BasicCredentials(username, password));
        return this;
    }

    @Override
    public <P> BasicMappingBuilder withPostServeAction(String extensionName, P parameters) {
        this.postServeActions.add(new PostServeActionDefinition(extensionName, BasicMappingBuilder.resolveParameters(parameters)));
        return this;
    }

    @Override
    public <P> MappingBuilder withServeEventListener(Set<ServeEventListener.RequestPhase> requestPhases, String extensionName, P parameters) {
        this.serveEventListeners.add(new ServeEventListenerDefinition(extensionName, requestPhases, BasicMappingBuilder.resolveParameters(parameters)));
        return this;
    }

    @Override
    public <P> MappingBuilder withServeEventListener(String extensionName, P parameters) {
        this.serveEventListeners.add(new ServeEventListenerDefinition(extensionName, BasicMappingBuilder.resolveParameters(parameters)));
        return this;
    }

    private static <P> Parameters resolveParameters(P parameters) {
        return parameters instanceof Parameters ? (Parameters)parameters : Parameters.of(parameters);
    }

    @Override
    public BasicMappingBuilder withMetadata(Map<String, ?> metadataMap) {
        this.metadata = new Metadata((Map<? extends String, ?>)metadataMap);
        return this;
    }

    @Override
    public BasicMappingBuilder withMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public BasicMappingBuilder withMetadata(Metadata.Builder metadata) {
        this.metadata = metadata.build();
        return this;
    }

    @Override
    public BasicMappingBuilder andMatching(ValueMatcher<Request> customMatcher) {
        this.requestPatternBuilder.andMatching(customMatcher);
        return this;
    }

    @Override
    public BasicMappingBuilder andMatching(String customRequestMatcherName) {
        this.requestPatternBuilder.andMatching(customRequestMatcherName);
        return this;
    }

    @Override
    public BasicMappingBuilder andMatching(String customRequestMatcherName, Parameters parameters) {
        this.requestPatternBuilder.andMatching(customRequestMatcherName, parameters);
        return this;
    }

    @Override
    public BasicMappingBuilder andMatching(CustomMatcherDefinition matcherDefinition) {
        this.requestPatternBuilder.andMatching(matcherDefinition);
        return this;
    }

    private boolean requiredScenarioExist() {
        return this.scenarioName == null && (this.requiredScenarioState != null || this.newScenarioState != null);
    }

    @Override
    public StubMapping build() {
        ParameterUtils.checkState(!this.requiredScenarioExist(), "Scenario name must be specified to require or set a new scenario state");
        RequestPattern requestPattern = this.requestPatternBuilder.build();
        ResponseDefinition response = ParameterUtils.getFirstNonNull(this.responseDefBuilder, WireMock.aResponse()).build();
        StubMapping mapping = new StubMapping(requestPattern, response);
        mapping.setPriority(this.priority);
        mapping.setScenarioName(this.scenarioName);
        mapping.setRequiredScenarioState(this.requiredScenarioState);
        mapping.setNewScenarioState(this.newScenarioState);
        mapping.setId(this.id);
        mapping.setName(this.name);
        mapping.setPersistent(this.isPersistent);
        mapping.setPostServeActions(this.postServeActions.isEmpty() ? null : this.postServeActions);
        mapping.setServeEventListenerDefinitions(this.serveEventListeners.isEmpty() ? null : this.serveEventListeners);
        mapping.setMetadata(this.metadata);
        return mapping;
    }
}

