/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.diff;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import wiremock.org.xmlunit.diff.Comparison;
import wiremock.org.xmlunit.diff.ComparisonListener;
import wiremock.org.xmlunit.diff.ComparisonResult;

public class ComparisonListenerSupport {
    private final List<ComparisonListener> compListeners = new CopyOnWriteArrayList<ComparisonListener>();
    private final List<ComparisonListener> matchListeners = new CopyOnWriteArrayList<ComparisonListener>();
    private final List<ComparisonListener> diffListeners = new CopyOnWriteArrayList<ComparisonListener>();

    public void addComparisonListener(ComparisonListener l) {
        this.compListeners.add(l);
    }

    public void addMatchListener(ComparisonListener l) {
        this.matchListeners.add(l);
    }

    public void addDifferenceListener(ComparisonListener l) {
        this.diffListeners.add(l);
    }

    public void fireComparisonPerformed(Comparison comparison, ComparisonResult outcome) {
        ComparisonListenerSupport.fire(comparison, outcome, this.compListeners);
        if (outcome == ComparisonResult.EQUAL) {
            ComparisonListenerSupport.fire(comparison, outcome, this.matchListeners);
        } else {
            ComparisonListenerSupport.fire(comparison, outcome, this.diffListeners);
        }
    }

    private static void fire(Comparison comparison, ComparisonResult outcome, List<ComparisonListener> listeners) {
        if (!listeners.isEmpty()) {
            for (ComparisonListener l : listeners) {
                l.comparisonPerformed(comparison, outcome);
            }
        }
    }
}

