/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.walk;

import java.util.List;
import java.util.Map;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.walk.AbstractWalkListenerRunner;
import wiremock.com.networknt.schema.walk.JsonSchemaWalkListener;
import wiremock.com.networknt.schema.walk.WalkEvent;

public class DefaultKeywordWalkListenerRunner
extends AbstractWalkListenerRunner {
    private Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap;

    public DefaultKeywordWalkListenerRunner(Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap) {
        this.keywordWalkListenersMap = keywordWalkListenersMap;
    }

    @Override
    public boolean runPreWalkListeners(ExecutionContext executionContext, String keyword, JsonNode instanceNode, JsonNode rootNode, JsonNodePath instanceLocation, JsonSchema schema, JsonValidator validator) {
        boolean continueRunningListenersAndWalk = true;
        WalkEvent keywordWalkEvent = this.constructWalkEvent(executionContext, keyword, instanceNode, rootNode, instanceLocation, schema, validator);
        List<JsonSchemaWalkListener> currentKeywordListeners = this.keywordWalkListenersMap.get(keyword);
        continueRunningListenersAndWalk = this.runPreWalkListeners(currentKeywordListeners, keywordWalkEvent);
        if (continueRunningListenersAndWalk) {
            List<JsonSchemaWalkListener> allKeywordListeners = this.keywordWalkListenersMap.get("wiremock.com.networknt.AllKeywordWalkListener");
            this.runPreWalkListeners(allKeywordListeners, keywordWalkEvent);
        }
        return continueRunningListenersAndWalk;
    }

    @Override
    public void runPostWalkListeners(ExecutionContext executionContext, String keyword, JsonNode instanceNode, JsonNode rootNode, JsonNodePath instanceLocation, JsonSchema schema, JsonValidator validator, Set<ValidationMessage> validationMessages) {
        WalkEvent keywordWalkEvent = this.constructWalkEvent(executionContext, keyword, instanceNode, rootNode, instanceLocation, schema, validator);
        List<JsonSchemaWalkListener> currentKeywordListeners = this.keywordWalkListenersMap.get(keyword);
        this.runPostWalkListeners(currentKeywordListeners, keywordWalkEvent, validationMessages);
        List<JsonSchemaWalkListener> allKeywordListeners = this.keywordWalkListenersMap.get("wiremock.com.networknt.AllKeywordWalkListener");
        this.runPostWalkListeners(allKeywordListeners, keywordWalkEvent, validationMessages);
    }
}

