/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.JsonNodePath;

public class JsonNodes {
    public static <T extends JsonNode> T get(JsonNode node, JsonNodePath path) {
        int nameCount = path.getNameCount();
        JsonNode current = node;
        for (int x = 0; x < nameCount; ++x) {
            Object segment = path.getElement(x);
            T result = JsonNodes.get(current, segment);
            if (result == null) {
                return null;
            }
            current = result;
        }
        return (T)current;
    }

    public static <T extends JsonNode> T get(JsonNode node, Object propertyOrIndex) {
        JsonNode value = null;
        if (propertyOrIndex instanceof Number) {
            value = node.get(((Number)propertyOrIndex).intValue());
        } else {
            String unescaped = propertyOrIndex.toString();
            if (unescaped.contains("~")) {
                unescaped = unescaped.replace("~1", "/");
                unescaped = unescaped.replace("~0", "~");
            }
            if (unescaped.contains("%")) {
                try {
                    unescaped = URLDecoder.decode(unescaped, StandardCharsets.UTF_8.toString());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            value = node.get(unescaped);
        }
        return (T)value;
    }
}

