/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.net.URI;
import java.net.URISyntaxException;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;

public interface JsonSchemaIdValidator {
    public static final JsonSchemaIdValidator DEFAULT = new DefaultJsonSchemaIdValidator();

    public boolean validate(String var1, boolean var2, SchemaLocation var3, SchemaLocation var4, ValidationContext var5);

    public static class DefaultJsonSchemaIdValidator
    implements JsonSchemaIdValidator {
        @Override
        public boolean validate(String id, boolean rootSchema, SchemaLocation schemaLocation, SchemaLocation resolvedSchemaLocation, ValidationContext validationContext) {
            if (this.hasNoContext(schemaLocation) && (this.isFragment(id) || this.startsWithSlash(id))) {
                return true;
            }
            return resolvedSchemaLocation.getAbsoluteIri() != null && this.isAbsoluteIri(resolvedSchemaLocation.getAbsoluteIri().toString());
        }

        protected boolean startsWithSlash(String id) {
            return id.startsWith("/");
        }

        protected boolean isFragment(String id) {
            return id.startsWith("#");
        }

        protected boolean hasNoContext(SchemaLocation schemaLocation) {
            return schemaLocation.getAbsoluteIri() == null || schemaLocation.toString().startsWith("#");
        }

        protected boolean isAbsoluteIri(String iri) {
            if (!iri.contains(":")) {
                return false;
            }
            try {
                new URI(iri);
            }
            catch (URISyntaxException e) {
                return false;
            }
            return true;
        }
    }
}

