/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import wiremock.com.networknt.schema.Collector;

public class CollectorContext {
    private Map<String, Object> collectorMap = new HashMap<String, Object>();
    private Map<String, Object> collectorLoadMap = new HashMap<String, Object>();

    public <E> void add(String name, Collector<E> collector) {
        this.collectorMap.put(name, collector);
    }

    public <E> void add(String name, Object object) {
        this.collectorMap.put(name, object);
    }

    public Object get(String name) {
        Object object = this.collectorMap.get(name);
        if (object instanceof Collector && this.collectorLoadMap.get(name) != null) {
            return this.collectorLoadMap.get(name);
        }
        return this.collectorMap.get(name);
    }

    public Map<String, Object> getCollectorMap() {
        return this.collectorMap;
    }

    public Map<String, Object> getAll() {
        HashMap<String, Object> mergedMap = new HashMap<String, Object>();
        mergedMap.putAll(this.collectorMap);
        mergedMap.putAll(this.collectorLoadMap);
        return mergedMap;
    }

    public void combineWithCollector(String name, Object data) {
        Object object = this.collectorMap.get(name);
        if (object instanceof Collector) {
            Collector collector = (Collector)object;
            collector.combine(data);
        }
    }

    void loadCollectors() {
        Set<Map.Entry<String, Object>> entrySet = this.collectorMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            if (!(entry.getValue() instanceof Collector)) continue;
            Collector collector = (Collector)entry.getValue();
            this.collectorLoadMap.put(entry.getKey(), collector.collect());
        }
    }
}

