/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.NetworkAddressRange;
import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.NetworkAddressUtils;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultNetworkAddressRules
implements NetworkAddressRules {
    private final Set<NetworkAddressRange> allowed;
    private final Set<NetworkAddressRange> allowedHostPatterns;
    private final Set<NetworkAddressRange> denied;
    private final Set<NetworkAddressRange> deniedHostPatterns;

    public DefaultNetworkAddressRules(Set<NetworkAddressRange> allowed, Set<NetworkAddressRange> denied) {
        this.allowed = DefaultNetworkAddressRules.defaultIfEmpty(allowed.stream().filter(networkAddressRange -> !(networkAddressRange instanceof NetworkAddressRange.DomainNameWildcard)).collect(Collectors.toSet()), NetworkAddressRange.ALL_RANGES);
        this.allowedHostPatterns = DefaultNetworkAddressRules.defaultIfEmpty(allowed.stream().filter(networkAddressRange -> networkAddressRange instanceof NetworkAddressRange.DomainNameWildcard).collect(Collectors.toSet()), NetworkAddressRange.ALL_RANGES);
        this.denied = denied.stream().filter(networkAddressRange -> !(networkAddressRange instanceof NetworkAddressRange.DomainNameWildcard)).collect(Collectors.toSet());
        this.deniedHostPatterns = denied.stream().filter(networkAddressRange -> networkAddressRange instanceof NetworkAddressRange.DomainNameWildcard).map(networkAddressRange -> (NetworkAddressRange.DomainNameWildcard)networkAddressRange).collect(Collectors.toSet());
    }

    private static <T> Set<T> defaultIfEmpty(Set<T> original, Set<T> ifEmpty) {
        if (original.isEmpty()) {
            return ifEmpty;
        }
        return original;
    }

    @Override
    public boolean isAllowed(String testValue) {
        if (NetworkAddressUtils.isValidInet4Address(testValue)) {
            return this.allowed.stream().anyMatch(rule -> rule.isIncluded(testValue)) && this.denied.stream().noneMatch(rule -> rule.isIncluded(testValue));
        }
        return this.allowedHostPatterns.stream().anyMatch(rule -> rule.isIncluded(testValue)) && this.deniedHostPatterns.stream().noneMatch(rule -> rule.isIncluded(testValue));
    }

    @Override
    public boolean isAllowedAll() {
        return this.allowed.equals(NetworkAddressRange.ALL_RANGES) && this.allowedHostPatterns.equals(NetworkAddressRange.ALL_RANGES) && this.denied.isEmpty() && this.deniedHostPatterns.isEmpty();
    }
}

