/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.placeholder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import wiremock.org.xmlunit.diff.Comparison;
import wiremock.org.xmlunit.diff.ComparisonResult;
import wiremock.org.xmlunit.diff.ComparisonType;
import wiremock.org.xmlunit.diff.DifferenceEvaluator;
import wiremock.org.xmlunit.placeholder.PlaceholderHandler;
import wiremock.org.xmlunit.util.Nodes;

public class PlaceholderDifferenceEvaluator
implements DifferenceEvaluator {
    public static final String PLACEHOLDER_DEFAULT_OPENING_DELIMITER_REGEX = Pattern.quote("${");
    public static final String PLACEHOLDER_DEFAULT_CLOSING_DELIMITER_REGEX = Pattern.quote("}");
    public static final String PLACEHOLDER_DEFAULT_ARGS_OPENING_DELIMITER_REGEX = Pattern.quote("(");
    public static final String PLACEHOLDER_DEFAULT_ARGS_CLOSING_DELIMITER_REGEX = Pattern.quote(")");
    public static final String PLACEHOLDER_DEFAULT_ARGS_SEPARATOR_REGEX = Pattern.quote(",");
    private static final String PLACEHOLDER_PREFIX_REGEX = Pattern.quote("xmlunit.");
    private static final Map<String, PlaceholderHandler> KNOWN_HANDLERS;
    private static final String[] NO_ARGS;
    private final Pattern placeholderRegex;
    private final Pattern argsRegex;
    private final String argsSplitter;

    public PlaceholderDifferenceEvaluator() {
        this(null, null);
    }

    public PlaceholderDifferenceEvaluator(String placeholderOpeningDelimiterRegex, String placeholderClosingDelimiterRegex) {
        this(placeholderOpeningDelimiterRegex, placeholderClosingDelimiterRegex, null, null, null);
    }

    public PlaceholderDifferenceEvaluator(String placeholderOpeningDelimiterRegex, String placeholderClosingDelimiterRegex, String placeholderArgsOpeningDelimiterRegex, String placeholderArgsClosingDelimiterRegex, String placeholderArgsSeparatorRegex) {
        if (placeholderOpeningDelimiterRegex == null || placeholderOpeningDelimiterRegex.trim().length() == 0) {
            placeholderOpeningDelimiterRegex = PLACEHOLDER_DEFAULT_OPENING_DELIMITER_REGEX;
        }
        if (placeholderClosingDelimiterRegex == null || placeholderClosingDelimiterRegex.trim().length() == 0) {
            placeholderClosingDelimiterRegex = PLACEHOLDER_DEFAULT_CLOSING_DELIMITER_REGEX;
        }
        if (placeholderArgsOpeningDelimiterRegex == null || placeholderArgsOpeningDelimiterRegex.trim().length() == 0) {
            placeholderArgsOpeningDelimiterRegex = PLACEHOLDER_DEFAULT_ARGS_OPENING_DELIMITER_REGEX;
        }
        if (placeholderArgsClosingDelimiterRegex == null || placeholderArgsClosingDelimiterRegex.trim().length() == 0) {
            placeholderArgsClosingDelimiterRegex = PLACEHOLDER_DEFAULT_ARGS_CLOSING_DELIMITER_REGEX;
        }
        if (placeholderArgsSeparatorRegex == null || placeholderArgsSeparatorRegex.trim().length() == 0) {
            placeholderArgsSeparatorRegex = PLACEHOLDER_DEFAULT_ARGS_SEPARATOR_REGEX;
        }
        this.placeholderRegex = Pattern.compile("(\\s*" + placeholderOpeningDelimiterRegex + "\\s*" + PLACEHOLDER_PREFIX_REGEX + "(.+)\\s*" + placeholderClosingDelimiterRegex + "\\s*)");
        this.argsRegex = Pattern.compile("((.*)\\s*" + placeholderArgsOpeningDelimiterRegex + "(.+)\\s*" + placeholderArgsClosingDelimiterRegex + "\\s*)");
        this.argsSplitter = placeholderArgsSeparatorRegex;
    }

    @Override
    public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
        if (outcome == ComparisonResult.EQUAL) {
            return outcome;
        }
        Comparison.Detail controlDetails = comparison.getControlDetails();
        Node controlTarget = controlDetails.getTarget();
        Comparison.Detail testDetails = comparison.getTestDetails();
        Node testTarget = testDetails.getTarget();
        if (comparison.getType() == ComparisonType.TEXT_VALUE) {
            return this.evaluateConsideringPlaceholders((String)controlDetails.getValue(), (String)testDetails.getValue(), outcome);
        }
        if (this.isMissingTextNodeDifference(comparison)) {
            return this.evaluateMissingTextNodeConsideringPlaceholders(comparison, outcome);
        }
        if (this.isTextCDATAMismatch(comparison)) {
            return this.evaluateConsideringPlaceholders(controlTarget.getNodeValue(), testTarget.getNodeValue(), outcome);
        }
        if (comparison.getType() == ComparisonType.ATTR_VALUE && controlDetails.getValue() instanceof String && testDetails.getValue() instanceof String) {
            return this.evaluateConsideringPlaceholders((String)controlDetails.getValue(), (String)testDetails.getValue(), outcome);
        }
        if (comparison.getType() == ComparisonType.ATTR_VALUE && controlDetails.getValue() instanceof QName && testDetails.getValue() instanceof QName) {
            return this.evaluateConsideringPlaceholders((QName)controlDetails.getValue(), (QName)testDetails.getValue(), outcome);
        }
        if (this.isMissingAttributeDifference(comparison)) {
            return this.evaluateMissingAttributeConsideringPlaceholders(comparison, outcome);
        }
        return outcome;
    }

    private boolean isMissingTextNodeDifference(Comparison comparison) {
        return this.controlHasOneTextChildAndTestHasNone(comparison) || this.cantFindControlTextChildInTest(comparison);
    }

    private boolean controlHasOneTextChildAndTestHasNone(Comparison comparison) {
        Comparison.Detail controlDetails = comparison.getControlDetails();
        Node controlTarget = controlDetails.getTarget();
        Comparison.Detail testDetails = comparison.getTestDetails();
        return comparison.getType() == ComparisonType.CHILD_NODELIST_LENGTH && Integer.valueOf(1).equals(controlDetails.getValue()) && Integer.valueOf(0).equals(testDetails.getValue()) && this.isTextLikeNode(controlTarget.getFirstChild());
    }

    private boolean cantFindControlTextChildInTest(Comparison comparison) {
        Node controlTarget = comparison.getControlDetails().getTarget();
        return comparison.getType() == ComparisonType.CHILD_LOOKUP && controlTarget != null && this.isTextLikeNode(controlTarget);
    }

    private ComparisonResult evaluateMissingTextNodeConsideringPlaceholders(Comparison comparison, ComparisonResult outcome) {
        Node controlTarget = comparison.getControlDetails().getTarget();
        String value = this.controlHasOneTextChildAndTestHasNone(comparison) ? controlTarget.getFirstChild().getNodeValue() : controlTarget.getNodeValue();
        return this.evaluateConsideringPlaceholders(value, null, outcome);
    }

    private boolean isTextCDATAMismatch(Comparison comparison) {
        return comparison.getType() == ComparisonType.NODE_TYPE && this.isTextLikeNode(comparison.getControlDetails().getTarget()) && this.isTextLikeNode(comparison.getTestDetails().getTarget());
    }

    private boolean isTextLikeNode(Node node) {
        short nodeType = node.getNodeType();
        return nodeType == 3 || nodeType == 4;
    }

    private boolean isMissingAttributeDifference(Comparison comparison) {
        return comparison.getType() == ComparisonType.ELEMENT_NUM_ATTRIBUTES || comparison.getType() == ComparisonType.ATTR_NAME_LOOKUP && comparison.getControlDetails().getTarget() != null && comparison.getControlDetails().getValue() != null;
    }

    private ComparisonResult evaluateMissingAttributeConsideringPlaceholders(Comparison comparison, ComparisonResult outcome) {
        if (comparison.getType() == ComparisonType.ELEMENT_NUM_ATTRIBUTES) {
            return this.evaluateAttributeListLengthConsideringPlaceholders(comparison, outcome);
        }
        String controlAttrValue = Nodes.getAttributes(comparison.getControlDetails().getTarget()).get((QName)comparison.getControlDetails().getValue());
        return this.evaluateConsideringPlaceholders(controlAttrValue, null, outcome);
    }

    private ComparisonResult evaluateAttributeListLengthConsideringPlaceholders(Comparison comparison, ComparisonResult outcome) {
        Map<QName, String> controlAttrs = Nodes.getAttributes(comparison.getControlDetails().getTarget());
        Map<QName, String> testAttrs = Nodes.getAttributes(comparison.getTestDetails().getTarget());
        int cAttrsMatched = 0;
        for (Map.Entry<QName, String> cAttr : controlAttrs.entrySet()) {
            String testValue = testAttrs.get(cAttr.getKey());
            if (testValue == null) {
                ComparisonResult o = this.evaluateConsideringPlaceholders(cAttr.getValue(), null, outcome);
                if (o == ComparisonResult.EQUAL) continue;
                return outcome;
            }
            ++cAttrsMatched;
        }
        if (cAttrsMatched != testAttrs.size()) {
            return outcome;
        }
        return ComparisonResult.EQUAL;
    }

    private ComparisonResult evaluateConsideringPlaceholders(QName controlQName, QName testQName, ComparisonResult outcome) {
        if (controlQName.getNamespaceURI().equals(testQName.getNamespaceURI())) {
            return this.evaluateConsideringPlaceholders(controlQName.getLocalPart(), testQName.getLocalPart(), outcome);
        }
        return outcome;
    }

    private ComparisonResult evaluateConsideringPlaceholders(String controlText, String testText, ComparisonResult outcome) {
        Matcher placeholderMatcher = this.placeholderRegex.matcher(controlText);
        if (placeholderMatcher.find()) {
            String[] args;
            String keyword;
            String content = placeholderMatcher.group(2).trim();
            Matcher argsMatcher = this.argsRegex.matcher(content);
            if (argsMatcher.find()) {
                keyword = argsMatcher.group(2).trim();
                args = argsMatcher.group(3).split(this.argsSplitter);
            } else {
                keyword = content;
                args = NO_ARGS;
            }
            if (this.isKnown(keyword)) {
                if (!placeholderMatcher.group(1).trim().equals(controlText.trim())) {
                    throw new RuntimeException("The placeholder must exclusively occupy the text node.");
                }
                return this.evaluate(keyword, testText, args);
            }
        }
        return outcome;
    }

    private boolean isKnown(String keyword) {
        return KNOWN_HANDLERS.containsKey(keyword);
    }

    private ComparisonResult evaluate(String keyword, String testText, String[] args) {
        return KNOWN_HANDLERS.get(keyword).evaluate(testText, args);
    }

    static {
        NO_ARGS = new String[0];
        HashMap<String, PlaceholderHandler> m = new HashMap<String, PlaceholderHandler>();
        for (PlaceholderHandler h : ServiceLoader.load(PlaceholderHandler.class)) {
            m.put(h.getKeyword(), h);
        }
        KNOWN_HANDLERS = Collections.unmodifiableMap(m);
    }
}

