/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import wiremock.org.eclipse.jetty.client.util.AsyncRequestContent;
import wiremock.org.eclipse.jetty.util.FutureCallback;

public class OutputStreamRequestContent
extends AsyncRequestContent {
    private final AsyncOutputStream output = new AsyncOutputStream();

    public OutputStreamRequestContent() {
        this("application/octet-stream");
    }

    public OutputStreamRequestContent(String contentType) {
        super(contentType, new ByteBuffer[0]);
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    private class AsyncOutputStream
    extends OutputStream {
        private AsyncOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                FutureCallback callback = new FutureCallback();
                OutputStreamRequestContent.this.offer(ByteBuffer.wrap(b, off, len), callback);
                callback.get();
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
            catch (ExecutionException x) {
                throw new IOException(x.getCause());
            }
        }

        @Override
        public void flush() throws IOException {
            OutputStreamRequestContent.this.flush();
        }

        @Override
        public void close() {
            OutputStreamRequestContent.this.close();
        }
    }
}

