/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.format;

import java.util.Map;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.ErrorMessageType;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.Keyword;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.SpecVersion;
import wiremock.com.networknt.schema.ValidationContext;

public abstract class BaseFormatJsonValidator
extends BaseJsonValidator {
    protected final boolean assertionsEnabled;

    public BaseFormatJsonValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ErrorMessageType errorMessageType, Keyword keyword, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, errorMessageType, keyword, validationContext, false);
        SpecVersion.VersionFlag dialect = this.validationContext.getMetaSchema().getSpecification();
        this.assertionsEnabled = dialect == null || dialect.getVersionFlagValue() < SpecVersion.VersionFlag.V201909.getVersionFlagValue() ? true : this.isFormatAssertionVocabularyEnabled(dialect, this.validationContext.getMetaSchema().getVocabularies());
    }

    protected boolean isFormatAssertionVocabularyEnabled() {
        return this.isFormatAssertionVocabularyEnabled(this.validationContext.getMetaSchema().getSpecification(), this.validationContext.getMetaSchema().getVocabularies());
    }

    protected boolean isFormatAssertionVocabularyEnabled(SpecVersion.VersionFlag specification, Map<String, Boolean> vocabularies) {
        if (SpecVersion.VersionFlag.V202012.equals((Object)specification)) {
            String vocabulary = "https://json-schema.org/draft/2020-12/vocab/format-assertion";
            return vocabularies.containsKey(vocabulary);
        }
        if (SpecVersion.VersionFlag.V201909.equals((Object)specification)) {
            String vocabulary = "https://json-schema.org/draft/2019-09/vocab/format";
            return vocabularies.getOrDefault(vocabulary, false);
        }
        return false;
    }

    protected boolean isAssertionsEnabled(ExecutionContext executionContext) {
        if (Boolean.TRUE.equals(executionContext.getExecutionConfig().getFormatAssertionsEnabled())) {
            return true;
        }
        if (Boolean.FALSE.equals(executionContext.getExecutionConfig().getFormatAssertionsEnabled())) {
            return false;
        }
        return this.assertionsEnabled;
    }
}

