/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Pair;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.wiremock.annotations.Beta;

@Beta(justification="Externalized State API: https://github.com/wiremock/wiremock/issues/2144")
public interface StubMappingStore {
    public Stream<StubMapping> getAll();

    public Optional<StubMapping> get(UUID var1);

    default public Stream<StubMapping> findAllMatchingRequest(Request request, Map<String, RequestMatcherExtension> customMatchers, Consumer<SubEvent> subEventConsumer) {
        return this.getAll().map(stubMapping -> Pair.pair(stubMapping, stubMapping.getRequest().match(request, customMatchers))).peek(stubAndMatchResult -> ((MatchResult)stubAndMatchResult.b).getSubEvents().forEach(subEventConsumer)).filter(stubAndMatchResult -> ((MatchResult)stubAndMatchResult.b).isExactMatch()).map(stubAndMatchResult -> (StubMapping)stubAndMatchResult.a);
    }

    public void add(StubMapping var1);

    public void replace(StubMapping var1, StubMapping var2);

    @Deprecated(forRemoval=true)
    public void remove(StubMapping var1);

    default public void remove(UUID stubMappingId) {
        this.remove(WireMock.any(WireMock.anyUrl()).withId(stubMappingId).build());
    }

    public void clear();
}

