/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.ChunkedDribbleDelay;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonInclude;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.fasterxml.jackson.databind.JsonNode;

public class ResponseDefinition {
    private final int status;
    private final String statusMessage;
    private final Body body;
    private final String bodyFileName;
    private final HttpHeaders headers;
    private final HttpHeaders additionalProxyRequestHeaders;
    private final List<String> removeProxyRequestHeaders;
    private final Integer fixedDelayMilliseconds;
    private final DelayDistribution delayDistribution;
    private final ChunkedDribbleDelay chunkedDribbleDelay;
    private final String proxyBaseUrl;
    private final String proxyUrlPrefixToRemove;
    private final Fault fault;
    private final List<String> transformers;
    private final Parameters transformerParameters;
    private String browserProxyUrl;
    private Boolean wasConfigured = true;
    private Request originalRequest;

    @JsonCreator
    public ResponseDefinition(@JsonProperty(value="status") int status, @JsonProperty(value="statusMessage") String statusMessage, @JsonProperty(value="body") String body, @JsonProperty(value="jsonBody") JsonNode jsonBody, @JsonProperty(value="base64Body") String base64Body, @JsonProperty(value="bodyFileName") String bodyFileName, @JsonProperty(value="headers") HttpHeaders headers, @JsonProperty(value="additionalProxyRequestHeaders") HttpHeaders additionalProxyRequestHeaders, @JsonProperty(value="removeProxyRequestHeaders") List<String> removeProxyRequestHeaders, @JsonProperty(value="fixedDelayMilliseconds") Integer fixedDelayMilliseconds, @JsonProperty(value="delayDistribution") DelayDistribution delayDistribution, @JsonProperty(value="chunkedDribbleDelay") ChunkedDribbleDelay chunkedDribbleDelay, @JsonProperty(value="proxyBaseUrl") String proxyBaseUrl, @JsonProperty(value="proxyUrlPrefixToRemove") String proxyUrlPrefixToRemove, @JsonProperty(value="fault") Fault fault, @JsonProperty(value="transformers") List<String> transformers, @JsonProperty(value="transformerParameters") Parameters transformerParameters, @JsonProperty(value="fromConfiguredStub") Boolean wasConfigured) {
        this(status, statusMessage, Body.fromOneOf(null, body, jsonBody, base64Body), bodyFileName, headers, additionalProxyRequestHeaders, removeProxyRequestHeaders, fixedDelayMilliseconds, delayDistribution, chunkedDribbleDelay, proxyBaseUrl, proxyUrlPrefixToRemove, fault, transformers, transformerParameters, wasConfigured);
    }

    public ResponseDefinition(int status, String statusMessage, byte[] body, JsonNode jsonBody, String base64Body, String bodyFileName, HttpHeaders headers, HttpHeaders additionalProxyRequestHeaders, List<String> removeProxyRequestHeaders, Integer fixedDelayMilliseconds, DelayDistribution delayDistribution, ChunkedDribbleDelay chunkedDribbleDelay, String proxyBaseUrl, String proxyUrlPrefixToRemove, Fault fault, List<String> transformers, Parameters transformerParameters, Boolean wasConfigured) {
        this(status, statusMessage, Body.fromOneOf(body, null, jsonBody, base64Body), bodyFileName, headers, additionalProxyRequestHeaders, removeProxyRequestHeaders, fixedDelayMilliseconds, delayDistribution, chunkedDribbleDelay, proxyBaseUrl, proxyUrlPrefixToRemove, fault, transformers, transformerParameters, wasConfigured);
    }

    public ResponseDefinition(int status, String statusMessage, Body body, String bodyFileName, HttpHeaders headers, HttpHeaders additionalProxyRequestHeaders, List<String> removeProxyRequestHeaders, Integer fixedDelayMilliseconds, DelayDistribution delayDistribution, ChunkedDribbleDelay chunkedDribbleDelay, String proxyBaseUrl, String proxyUrlPrefixToRemove, Fault fault, List<String> transformers, Parameters transformerParameters, Boolean wasConfigured) {
        this.status = status > 0 ? status : 200;
        this.statusMessage = statusMessage;
        this.body = body;
        this.bodyFileName = bodyFileName;
        this.headers = headers;
        this.additionalProxyRequestHeaders = additionalProxyRequestHeaders;
        this.removeProxyRequestHeaders = removeProxyRequestHeaders;
        this.fixedDelayMilliseconds = fixedDelayMilliseconds;
        this.delayDistribution = delayDistribution;
        this.chunkedDribbleDelay = chunkedDribbleDelay;
        this.proxyBaseUrl = proxyBaseUrl == null ? null : proxyBaseUrl.trim();
        this.proxyUrlPrefixToRemove = proxyUrlPrefixToRemove;
        this.fault = fault;
        this.transformers = transformers;
        this.transformerParameters = transformerParameters;
        this.wasConfigured = wasConfigured == null ? true : wasConfigured;
    }

    public ResponseDefinition(int statusCode, String bodyContent) {
        this(statusCode, null, Body.fromString(bodyContent), null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), Parameters.empty(), true);
    }

    public ResponseDefinition(int statusCode, byte[] bodyContent) {
        this(statusCode, null, Body.fromBytes(bodyContent), null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), Parameters.empty(), true);
    }

    public ResponseDefinition() {
        this(200, null, Body.none(), null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), Parameters.empty(), true);
    }

    public static ResponseDefinition notFound() {
        return new ResponseDefinition(404, (byte[])null);
    }

    public static ResponseDefinition ok() {
        return new ResponseDefinition(200, (byte[])null);
    }

    public static ResponseDefinition okEmptyJson() {
        return ResponseDefinitionBuilder.okForEmptyJson().build();
    }

    public static <T> ResponseDefinition okForJson(T body) {
        return ResponseDefinitionBuilder.okForJson(body).build();
    }

    public static ResponseDefinition created() {
        return new ResponseDefinition(201, (byte[])null);
    }

    public static ResponseDefinition noContent() {
        return new ResponseDefinition(204, (byte[])null);
    }

    public static ResponseDefinition badRequest(Errors errors) {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(400).withHeader("Content-Type", "application/json").withBody(Json.write(errors)).build();
    }

    public static ResponseDefinition badRequestEntity(Errors errors) {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(422).withHeader("Content-Type", "application/json").withBody(Json.write(errors)).build();
    }

    public static ResponseDefinition redirectTo(String path) {
        return new ResponseDefinitionBuilder().withHeader("Location", path).withStatus(302).build();
    }

    public static ResponseDefinition notConfigured() {
        ResponseDefinition response = new ResponseDefinition(404, (byte[])null);
        response.wasConfigured = false;
        return response;
    }

    public static ResponseDefinition notAuthorised() {
        return new ResponseDefinition(401, (byte[])null);
    }

    public static ResponseDefinition notPermitted(String message) {
        return ResponseDefinition.notPermitted(Errors.single(40, message));
    }

    public static ResponseDefinition notPermitted(Errors errors) {
        return ResponseDefinitionBuilder.jsonResponse(errors, 403);
    }

    public static ResponseDefinition browserProxy(Request originalRequest) {
        ResponseDefinition response = new ResponseDefinition();
        response.browserProxyUrl = originalRequest.getAbsoluteUrl();
        return response;
    }

    public static ResponseDefinition copyOf(ResponseDefinition original) {
        return original.copy();
    }

    public ResponseDefinition copy() {
        ResponseDefinition newResponseDef = new ResponseDefinition(this.status, this.statusMessage, this.body, this.bodyFileName, this.headers, this.additionalProxyRequestHeaders, this.removeProxyRequestHeaders, this.fixedDelayMilliseconds, this.delayDistribution, this.chunkedDribbleDelay, this.proxyBaseUrl, this.proxyUrlPrefixToRemove, this.fault, this.transformers, this.transformerParameters, this.wasConfigured);
        return newResponseDef;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpHeaders getAdditionalProxyRequestHeaders() {
        return this.additionalProxyRequestHeaders;
    }

    public List<String> getRemoveProxyRequestHeaders() {
        return this.removeProxyRequestHeaders;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getBody() {
        return !this.body.isBinary() && !this.body.isJson() ? this.body.asString() : null;
    }

    @JsonIgnore
    public String getTextBody() {
        return !this.body.isBinary() ? this.body.asString() : null;
    }

    @JsonIgnore
    public byte[] getByteBody() {
        return this.body.asBytes();
    }

    @JsonIgnore
    public byte[] getByteBodyIfBinary() {
        return this.body.isBinary() ? this.body.asBytes() : null;
    }

    public String getBase64Body() {
        return this.body.isBinary() ? this.body.asBase64() : null;
    }

    @JsonIgnore
    public Body getReponseBody() {
        return this.body;
    }

    public JsonNode getJsonBody() {
        return this.body.isJson() ? this.body.asJson() : null;
    }

    public String getBodyFileName() {
        return this.bodyFileName;
    }

    public boolean wasConfigured() {
        return this.wasConfigured == null || this.wasConfigured != false;
    }

    public Boolean isFromConfiguredStub() {
        return this.wasConfigured == null || this.wasConfigured != false ? null : Boolean.valueOf(false);
    }

    public Integer getFixedDelayMilliseconds() {
        return this.fixedDelayMilliseconds;
    }

    public DelayDistribution getDelayDistribution() {
        return this.delayDistribution;
    }

    public ChunkedDribbleDelay getChunkedDribbleDelay() {
        return this.chunkedDribbleDelay;
    }

    @JsonIgnore
    public String getProxyUrl() {
        if (this.browserProxyUrl != null) {
            return this.browserProxyUrl;
        }
        String originalRequestUrl = Optional.ofNullable(this.originalRequest).map(Request::getUrl).orElse("");
        return this.proxyBaseUrl + Strings.removeStart(originalRequestUrl, this.proxyUrlPrefixToRemove);
    }

    public String getProxyBaseUrl() {
        return this.proxyBaseUrl;
    }

    public String getProxyUrlPrefixToRemove() {
        return this.proxyUrlPrefixToRemove;
    }

    @JsonIgnore
    public boolean specifiesBodyFile() {
        return this.bodyFileName != null && this.body.isAbsent();
    }

    @JsonIgnore
    public boolean specifiesBodyContent() {
        return this.body.isPresent();
    }

    @JsonIgnore
    public boolean specifiesTextBodyContent() {
        return this.body.isPresent() && !this.body.isBinary();
    }

    @JsonIgnore
    public boolean specifiesBinaryBodyContent() {
        return this.body.isPresent() && this.body.isBinary();
    }

    @JsonIgnore
    public boolean isProxyResponse() {
        return this.browserProxyUrl != null || this.proxyBaseUrl != null;
    }

    @JsonIgnore
    public Request getOriginalRequest() {
        return this.originalRequest;
    }

    public void setOriginalRequest(Request originalRequest) {
        this.originalRequest = originalRequest;
    }

    public Fault getFault() {
        return this.fault;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getTransformers() {
        return this.transformers;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Parameters getTransformerParameters() {
        return this.transformerParameters;
    }

    public boolean hasTransformer(Extension transformer) {
        return this.transformers != null && this.transformers.contains(transformer.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseDefinition that = (ResponseDefinition)o;
        return this.status == that.status && Objects.equals(this.statusMessage, that.statusMessage) && Objects.equals(this.body, that.body) && Objects.equals(this.bodyFileName, that.bodyFileName) && Objects.equals(this.headers, that.headers) && Objects.equals(this.additionalProxyRequestHeaders, that.additionalProxyRequestHeaders) && Objects.equals(this.removeProxyRequestHeaders, that.removeProxyRequestHeaders) && Objects.equals(this.fixedDelayMilliseconds, that.fixedDelayMilliseconds) && Objects.equals(this.delayDistribution, that.delayDistribution) && Objects.equals(this.chunkedDribbleDelay, that.chunkedDribbleDelay) && Objects.equals(this.proxyBaseUrl, that.proxyBaseUrl) && Objects.equals(this.proxyUrlPrefixToRemove, that.proxyUrlPrefixToRemove) && this.fault == that.fault && Objects.equals(this.transformers, that.transformers) && Objects.equals(this.transformerParameters, that.transformerParameters) && Objects.equals(this.browserProxyUrl, that.browserProxyUrl) && Objects.equals(this.wasConfigured, that.wasConfigured);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.statusMessage, this.body, this.bodyFileName, this.headers, this.additionalProxyRequestHeaders, this.removeProxyRequestHeaders, this.fixedDelayMilliseconds, this.delayDistribution, this.chunkedDribbleDelay, this.proxyBaseUrl, this.proxyUrlPrefixToRemove, this.fault, this.transformers, this.transformerParameters, this.browserProxyUrl, this.wasConfigured});
    }

    public String toString() {
        return this.wasConfigured != false ? Json.write(this) : "(no response definition configured)";
    }
}

