/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.xpath;

import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import wiremock.org.xmlunit.ConfigurationException;
import wiremock.org.xmlunit.XMLUnitException;
import wiremock.org.xmlunit.util.Convert;
import wiremock.org.xmlunit.util.IterableNodeList;
import wiremock.org.xmlunit.util.XPathFactoryConfigurer;
import wiremock.org.xmlunit.xpath.XPathEngine;

public class JAXPXPathEngine
implements XPathEngine {
    private final XPath xpath;

    public JAXPXPathEngine(XPathFactory fac) {
        try {
            this.xpath = fac.newXPath();
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public JAXPXPathEngine() {
        this(XPathFactoryConfigurer.Default.configure(XPathFactory.newInstance()));
    }

    @Override
    public Iterable<Node> selectNodes(String xPath, Source s) {
        try {
            return new IterableNodeList((NodeList)this.xpath.evaluate(xPath, Convert.toInputSource(s), XPathConstants.NODESET));
        }
        catch (XPathExpressionException ex) {
            throw new XMLUnitException(ex);
        }
    }

    @Override
    public String evaluate(String xPath, Source s) {
        try {
            return this.xpath.evaluate(xPath, Convert.toInputSource(s));
        }
        catch (XPathExpressionException ex) {
            throw new XMLUnitException(ex);
        }
    }

    @Override
    public Iterable<Node> selectNodes(String xPath, Node n) {
        try {
            return new IterableNodeList((NodeList)this.xpath.evaluate(xPath, n, XPathConstants.NODESET));
        }
        catch (XPathExpressionException ex) {
            throw new XMLUnitException(ex);
        }
    }

    @Override
    public String evaluate(String xPath, Node n) {
        try {
            return this.xpath.evaluate(xPath, n);
        }
        catch (XPathExpressionException ex) {
            throw new XMLUnitException(ex);
        }
    }

    @Override
    public void setNamespaceContext(Map<String, String> prefix2Uri) {
        this.xpath.setNamespaceContext(Convert.toNamespaceContext(prefix2Uri));
    }
}

