/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.CustomMatcherDefinition;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePatternBuilder;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPathTemplatePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RequestPatternBuilder {
    private String scheme;
    private StringValuePattern hostPattern;
    private Integer port;
    private StringValuePattern clientIpPattern;
    private UrlPattern url = UrlPattern.ANY;
    private RequestMethod method = RequestMethod.ANY;
    private Map<String, MultiValuePattern> headers = new LinkedHashMap<String, MultiValuePattern>();
    private Map<String, MultiValuePattern> queryParams = new LinkedHashMap<String, MultiValuePattern>();
    private Map<String, MultiValuePattern> formParams = new LinkedHashMap<String, MultiValuePattern>();
    private Map<String, StringValuePattern> pathParams = new LinkedHashMap<String, StringValuePattern>();
    private List<ContentPattern<?>> bodyPatterns = new ArrayList();
    private Map<String, StringValuePattern> cookies = new LinkedHashMap<String, StringValuePattern>();
    private BasicCredentials basicCredentials;
    private List<MultipartValuePattern> multiparts = new LinkedList<MultipartValuePattern>();
    private ValueMatcher<Request> customMatcher;
    private CustomMatcherDefinition customMatcherDefinition;

    public RequestPatternBuilder() {
    }

    public RequestPatternBuilder(ValueMatcher<Request> customMatcher) {
        this.customMatcher = customMatcher;
    }

    public RequestPatternBuilder(RequestMethod method, UrlPattern url) {
        this.method = method;
        this.url = url;
    }

    public RequestPatternBuilder(String customRequestMatcherName, Parameters parameters) {
        this.customMatcherDefinition = new CustomMatcherDefinition(customRequestMatcherName, parameters);
    }

    public static RequestPatternBuilder newRequestPattern(RequestMethod method, UrlPattern url) {
        return new RequestPatternBuilder(method, url);
    }

    public static RequestPatternBuilder newRequestPattern() {
        return new RequestPatternBuilder();
    }

    public static RequestPatternBuilder forCustomMatcher(ValueMatcher<Request> requestMatcher) {
        return new RequestPatternBuilder(requestMatcher);
    }

    public static RequestPatternBuilder forCustomMatcher(String customRequestMatcherName, Parameters parameters) {
        return new RequestPatternBuilder(customRequestMatcherName, parameters);
    }

    public static RequestPatternBuilder allRequests() {
        return new RequestPatternBuilder(RequestMethod.ANY, WireMock.anyUrl());
    }

    public static RequestPatternBuilder like(RequestPattern requestPattern) {
        RequestPatternBuilder builder = new RequestPatternBuilder();
        builder.scheme = requestPattern.getScheme();
        builder.hostPattern = requestPattern.getHost();
        builder.port = requestPattern.getPort();
        builder.clientIpPattern = requestPattern.getClientIp();
        builder.url = requestPattern.getUrlMatcher();
        builder.method = requestPattern.getMethod();
        if (requestPattern.getHeaders() != null) {
            builder.headers = requestPattern.getHeaders();
        }
        if (requestPattern.getPathParameters() != null) {
            builder.pathParams = requestPattern.getPathParameters();
        }
        if (requestPattern.getQueryParameters() != null) {
            builder.queryParams = requestPattern.getQueryParameters();
        }
        if (requestPattern.getFormParameters() != null) {
            builder.formParams = requestPattern.getFormParameters();
        }
        if (requestPattern.getCookies() != null) {
            builder.cookies = requestPattern.getCookies();
        }
        if (requestPattern.getBodyPatterns() != null) {
            builder.bodyPatterns = requestPattern.getBodyPatterns();
        }
        if (requestPattern.hasInlineCustomMatcher()) {
            builder.customMatcher = requestPattern.getMatcher();
        }
        if (requestPattern.getMultipartPatterns() != null) {
            builder.multiparts = requestPattern.getMultipartPatterns();
        }
        builder.basicCredentials = requestPattern.getBasicAuthCredentials();
        builder.customMatcherDefinition = requestPattern.getCustomMatcher();
        return builder;
    }

    public RequestPatternBuilder but() {
        return this;
    }

    public RequestPatternBuilder withScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public RequestPatternBuilder withHost(StringValuePattern hostPattern) {
        this.hostPattern = hostPattern;
        return this;
    }

    public RequestPatternBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public RequestPatternBuilder withClientIp(StringValuePattern clientIpPattern) {
        this.clientIpPattern = clientIpPattern;
        return this;
    }

    public RequestPatternBuilder withUrl(String url) {
        this.url = WireMock.urlEqualTo(url);
        return this;
    }

    public RequestPatternBuilder withUrl(UrlPattern urlPattern) {
        this.url = urlPattern;
        return this;
    }

    public RequestPatternBuilder withHeader(String key, StringValuePattern valuePattern) {
        this.headers.put(key, MultiValuePattern.of(valuePattern));
        return this;
    }

    public RequestPatternBuilder withHeader(String key, MultiValuePattern multiValuePattern) {
        this.headers.put(key, multiValuePattern);
        return this;
    }

    public RequestPatternBuilder withoutHeader(String key) {
        this.headers.put(key, MultiValuePattern.absent());
        return this;
    }

    public RequestPatternBuilder withPathParam(String key, StringValuePattern valuePattern) {
        this.pathParams.put(key, valuePattern);
        return this;
    }

    public RequestPatternBuilder withQueryParam(String key, StringValuePattern valuePattern) {
        this.queryParams.put(key, MultiValuePattern.of(valuePattern));
        return this;
    }

    public RequestPatternBuilder withQueryParam(String key, MultiValuePattern multiValuePattern) {
        this.queryParams.put(key, multiValuePattern);
        return this;
    }

    public RequestPatternBuilder withFormParam(String key, StringValuePattern valuePattern) {
        this.formParams.put(key, MultiValuePattern.of(valuePattern));
        return this;
    }

    public RequestPatternBuilder withFormParam(String key, MultiValuePattern multiValuePattern) {
        this.formParams.put(key, multiValuePattern);
        return this;
    }

    public RequestPatternBuilder withoutFormParam(String key) {
        this.formParams.put(key, MultiValuePattern.absent());
        return this;
    }

    public RequestPatternBuilder withoutQueryParam(String key) {
        this.queryParams.put(key, MultiValuePattern.absent());
        return this;
    }

    public RequestPatternBuilder withCookie(String key, StringValuePattern valuePattern) {
        this.cookies.put(key, valuePattern);
        return this;
    }

    public RequestPatternBuilder withBasicAuth(BasicCredentials basicCredentials) {
        this.basicCredentials = basicCredentials;
        return this;
    }

    public RequestPatternBuilder withRequestBody(ContentPattern valuePattern) {
        this.bodyPatterns.add(valuePattern);
        return this;
    }

    public RequestPatternBuilder withRequestBodyPart(MultipartValuePattern multiPattern) {
        if (multiPattern != null) {
            this.multiparts.add(multiPattern);
        }
        return this;
    }

    public RequestPatternBuilder withAnyRequestBodyPart(MultipartValuePatternBuilder multiPatternBuilder) {
        return this.withRequestBodyPart(multiPatternBuilder.matchingType(MultipartValuePattern.MatchingType.ANY).build());
    }

    public RequestPatternBuilder withAllRequestBodyParts(MultipartValuePatternBuilder multiPatternBuilder) {
        return this.withRequestBodyPart(multiPatternBuilder.matchingType(MultipartValuePattern.MatchingType.ALL).build());
    }

    public RequestPatternBuilder andMatching(ValueMatcher<Request> customMatcher) {
        this.customMatcher = customMatcher;
        return this;
    }

    public RequestPatternBuilder andMatching(String customRequestMatcherName) {
        return this.andMatching(customRequestMatcherName, Parameters.empty());
    }

    public RequestPatternBuilder andMatching(String customRequestMatcherName, Parameters parameters) {
        return this.andMatching(new CustomMatcherDefinition(customRequestMatcherName, parameters));
    }

    public RequestPatternBuilder andMatching(CustomMatcherDefinition matcherDefinition) {
        this.customMatcherDefinition = matcherDefinition;
        return this;
    }

    public RequestPattern build() {
        if (!(this.url instanceof UrlPathTemplatePattern) && !this.pathParams.isEmpty()) {
            throw new InvalidInputException(Errors.single(19, "URL path parameters specified without a path template as the URL matcher"));
        }
        return new RequestPattern(this.scheme, this.hostPattern, this.port, this.clientIpPattern, this.url, this.method, this.headers.isEmpty() ? null : this.headers, this.pathParams.isEmpty() ? null : this.pathParams, this.queryParams.isEmpty() ? null : this.queryParams, this.formParams.isEmpty() ? null : this.formParams, this.cookies.isEmpty() ? null : this.cookies, this.basicCredentials, this.bodyPatterns.isEmpty() ? null : this.bodyPatterns, this.customMatcherDefinition, this.customMatcher, this.multiparts.isEmpty() ? null : this.multiparts);
    }
}

