/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.function.Function;
import java.util.function.IntPredicate;

public enum PathType {
    LEGACY("$", token -> "." + PathType.replaceCommonSpecialCharactersIfPresent(token), index -> "[" + index + "]"),
    JSON_PATH("$", token -> {
        if (token.isEmpty()) {
            throw new IllegalArgumentException("A JSONPath selector cannot be empty");
        }
        if (JSONPath.isShorthand(token)) {
            return "." + token;
        }
        if (token.indexOf(39) != -1) {
            token = token.replace("'", "\\'");
        }
        token = PathType.replaceCommonSpecialCharactersIfPresent(token);
        return "['" + token + "']";
    }, index -> "[" + index + "]"),
    JSON_POINTER("", token -> {
        if (token.indexOf(126) != -1) {
            token = token.replace("~", "~0");
        }
        if (token.indexOf(47) != -1) {
            token = token.replace("/", "~1");
        }
        token = PathType.replaceCommonSpecialCharactersIfPresent(token);
        return "/" + token;
    }, index -> "/" + index);

    public static final PathType DEFAULT;
    private final String rootToken;
    private final Function<String, String> appendTokenFn;
    private final Function<Integer, String> appendIndexFn;

    private PathType(String rootToken, Function<String, String> appendTokenFn, Function<Integer, String> appendIndexFn) {
        this.rootToken = rootToken;
        this.appendTokenFn = appendTokenFn;
        this.appendIndexFn = appendIndexFn;
    }

    private static String replaceCommonSpecialCharactersIfPresent(String token) {
        if (token.indexOf(10) != -1) {
            token = token.replace("\n", "\\n");
        }
        if (token.indexOf(9) != -1) {
            token = token.replace("\t", "\\t");
        }
        if (token.indexOf(13) != -1) {
            token = token.replace("\r", "\\r");
        }
        if (token.indexOf(8) != -1) {
            token = token.replace("\b", "\\b");
        }
        if (token.indexOf(12) != -1) {
            token = token.replace("\f", "\\f");
        }
        return token;
    }

    public String append(String currentPath, String child) {
        return currentPath + this.appendTokenFn.apply(child);
    }

    public String append(String currentPath, int index) {
        return currentPath + this.appendIndexFn.apply(index);
    }

    public String getRoot() {
        return this.rootToken;
    }

    public String convertToJsonPointer(String path) {
        switch (this) {
            case JSON_POINTER: {
                return path;
            }
            case JSON_PATH: {
                return PathType.fromJsonPath(path);
            }
        }
        return PathType.fromLegacy(path);
    }

    static String fromLegacy(String path) {
        return path.replace("\"", "").replace("]", "").replace('[', '/').replace('.', '/').replace("$", "");
    }

    static String fromJsonPath(String str) {
        if (null == str || str.isEmpty() || '$' != str.charAt(0)) {
            throw new IllegalArgumentException("JSON Path must start with '$'");
        }
        String tail = str.substring(1);
        if (tail.isEmpty()) {
            return "";
        }
        int len = tail.length();
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        block4: while (i < len) {
            char c = tail.charAt(i);
            switch (c) {
                case '.': {
                    sb.append('/');
                    i = PathType.parseShorthand(sb, tail, i + 1);
                    continue block4;
                }
                case '[': {
                    sb.append('/');
                    i = PathType.parseSelector(sb, tail, i + 1);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("JSONPath must reference a property or array index");
        }
        return sb.toString();
    }

    static int parseShorthand(StringBuilder sb, String s2, int pos) {
        int i;
        int len = s2.length();
        block3: for (i = pos; i < len; ++i) {
            char c = s2.charAt(i);
            switch (c) {
                case '.': 
                case '[': {
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return i;
    }

    static int parseSelector(StringBuilder sb, String s2, int pos) {
        int close = s2.indexOf(93, pos);
        if (-1 == close) {
            throw new IllegalArgumentException("JSONPath contains an unterminated selector");
        }
        if ('\'' == s2.charAt(pos)) {
            PathType.parseQuote(sb, s2, pos + 1);
        } else {
            sb.append(s2.substring(pos, close));
        }
        return close + 1;
    }

    static int parseQuote(StringBuilder sb, String s2, int pos) {
        int close = pos;
        do {
            if (-1 != (close = s2.indexOf(39, close))) continue;
            throw new IllegalArgumentException("JSONPath contains an unterminated quoted string");
        } while ('\\' == s2.charAt(close - 1));
        sb.append(s2.substring(pos, close));
        return close + 1;
    }

    static {
        DEFAULT = LEGACY;
    }

    static class JSONPath {
        public static final IntPredicate ALPHA = c -> c >= 97 && c <= 122 || c >= 65 && c <= 90;
        public static final IntPredicate DIGIT = c -> c >= 48 && c <= 57;
        public static final IntPredicate NON_ASCII = c -> c >= 128 && c <= 0x10FFFF;
        public static final IntPredicate UNDERSCORE = c -> 95 == c;
        public static final IntPredicate NAME_FIRST = ALPHA.or(UNDERSCORE).or(NON_ASCII);
        public static final IntPredicate NAME_CHAR = NAME_FIRST.or(DIGIT);

        JSONPath() {
        }

        public static boolean isShorthand(String selector) {
            if (null == selector || selector.isEmpty()) {
                throw new IllegalArgumentException("A JSONPath selector cannot be empty");
            }
            return NAME_FIRST.test(selector.codePointAt(0)) && selector.codePoints().skip(1L).allMatch(NAME_CHAR);
        }
    }
}

