/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty;

import com.github.tomakehurst.wiremock.common.AsynchronousResponseSettings;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ResourceUtil;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.http.trafficlistener.WiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.jetty.DefaultMultipartRequestConfigurer;
import com.github.tomakehurst.wiremock.jetty.JettyFaultInjectorFactory;
import com.github.tomakehurst.wiremock.jetty.NotFoundHandler;
import com.github.tomakehurst.wiremock.servlet.ContentTypeSettingFilter;
import com.github.tomakehurst.wiremock.servlet.MultipartRequestConfigurer;
import com.github.tomakehurst.wiremock.servlet.NotMatchedServlet;
import com.github.tomakehurst.wiremock.servlet.TrailingSlashFilter;
import com.github.tomakehurst.wiremock.servlet.WireMockHandlerDispatchingServlet;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import wiremock.jakarta.servlet.DispatcherType;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.jakarta.servlet.http.HttpServletResponse;
import wiremock.org.apache.commons.lang3.ArrayUtils;
import wiremock.org.apache.commons.lang3.mutable.MutableBoolean;
import wiremock.org.eclipse.jetty.http.MimeTypes;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.NetworkTrafficListener;
import wiremock.org.eclipse.jetty.server.Handler;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Server;
import wiremock.org.eclipse.jetty.server.ServerConnector;
import wiremock.org.eclipse.jetty.server.handler.AbstractHandler;
import wiremock.org.eclipse.jetty.server.handler.HandlerCollection;
import wiremock.org.eclipse.jetty.server.handler.gzip.GzipHandler;
import wiremock.org.eclipse.jetty.servlet.DefaultServlet;
import wiremock.org.eclipse.jetty.servlet.FilterHolder;
import wiremock.org.eclipse.jetty.servlet.ServletContextHandler;
import wiremock.org.eclipse.jetty.servlet.ServletHolder;
import wiremock.org.eclipse.jetty.servlets.CrossOriginFilter;

public abstract class JettyHttpServer
implements HttpServer {
    private static final String FILES_URL_MATCH = String.format("/%s/*", "__files");
    private static final String[] GZIPPABLE_METHODS = new String[]{"POST", "PUT", "PATCH", "DELETE"};
    private static final MutableBoolean STRICT_HTTP_HEADERS_APPLIED = new MutableBoolean(false);
    protected final Server jettyServer;
    protected final ServerConnector httpConnector;
    protected final ServerConnector httpsConnector;
    protected ScheduledExecutorService scheduledExecutorService;

    public JettyHttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        if (!options.getDisableStrictHttpHeaders() && STRICT_HTTP_HEADERS_APPLIED.isFalse()) {
            System.setProperty("wiremock.org.eclipse.jetty.http.HttpGenerator.STRICT", String.valueOf(true));
            STRICT_HTTP_HEADERS_APPLIED.setTrue();
        }
        this.jettyServer = this.createServer(options);
        NetworkTrafficListenerAdapter networkTrafficListenerAdapter = new NetworkTrafficListenerAdapter(options.networkTrafficListener());
        if (options.getHttpDisabled()) {
            this.httpConnector = null;
        } else {
            this.httpConnector = this.createHttpConnector(options.bindAddress(), options.portNumber(), options.jettySettings(), networkTrafficListenerAdapter);
            this.jettyServer.addConnector(this.httpConnector);
        }
        if (options.httpsSettings().enabled()) {
            this.httpsConnector = this.createHttpsConnector(options.bindAddress(), options.httpsSettings(), options.jettySettings(), networkTrafficListenerAdapter);
            this.jettyServer.addConnector(this.httpsConnector);
        } else {
            this.httpsConnector = null;
        }
        this.applyAdditionalServerConfiguration(this.jettyServer, options);
        HandlerCollection handlers = this.createHandler(options, adminRequestHandler, stubRequestHandler);
        this.jettyServer.setHandler(handlers);
        this.finalizeSetup(options);
    }

    protected void applyAdditionalServerConfiguration(Server jettyServer, Options options) {
    }

    protected HandlerCollection createHandler(final Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        Notifier notifier = options.notifier();
        ServletContextHandler adminContext = this.addAdminContext(adminRequestHandler, notifier);
        ServletContextHandler mockServiceContext = this.addMockServiceContext(stubRequestHandler, options.filesRoot(), options.getAsynchronousResponseSettings(), options.getChunkedEncodingPolicy(), options.getStubCorsEnabled(), options.browserProxySettings().enabled(), notifier);
        HandlerCollection handlers = new HandlerCollection();
        AbstractHandler asyncTimeoutSettingHandler = new AbstractHandler(){

            @Override
            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                baseRequest.getHttpChannel().getState().setTimeout(options.timeout());
            }
        };
        handlers.setHandlers(ArrayUtils.addAll(this.extensionHandlers(), adminContext, asyncTimeoutSettingHandler));
        if (options.getGzipDisabled()) {
            handlers.addHandler(mockServiceContext);
        } else {
            this.addGZipHandler(mockServiceContext, handlers);
        }
        return handlers;
    }

    private void addGZipHandler(ServletContextHandler mockServiceContext, HandlerCollection handlers) {
        try {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.addIncludedMethods(GZIPPABLE_METHODS);
            gzipHandler.setHandler(mockServiceContext);
            gzipHandler.setVary(null);
            handlers.addHandler(gzipHandler);
        }
        catch (Exception e) {
            Exceptions.throwUnchecked(e);
        }
    }

    protected void finalizeSetup(Options options) {
        if (options.jettySettings().getStopTimeout().isEmpty()) {
            this.jettyServer.setStopTimeout(1000L);
        }
    }

    protected Server createServer(Options options) {
        Server server = new Server(options.threadPoolFactory().buildThreadPool(options));
        JettySettings jettySettings = options.jettySettings();
        Optional<Long> stopTimeout = jettySettings.getStopTimeout();
        stopTimeout.ifPresent(server::setStopTimeout);
        return server;
    }

    protected Handler[] extensionHandlers() {
        return new Handler[0];
    }

    @Override
    public void start() {
        try {
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long timeout = System.currentTimeMillis() + 30000L;
        while (!this.jettyServer.isStarted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= timeout) continue;
            throw new RuntimeException("Server took too long to start up.");
        }
    }

    @Override
    public void stop() {
        try {
            if (this.scheduledExecutorService != null) {
                this.scheduledExecutorService.shutdown();
            }
            if (this.httpConnector != null) {
                this.httpConnector.getConnectedEndPoints().forEach(EndPoint::close);
            }
            if (this.httpsConnector != null) {
                this.httpsConnector.getConnectedEndPoints().forEach(EndPoint::close);
            }
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (TimeoutException timeoutException) {
        }
        catch (Exception e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.jettyServer.isRunning();
    }

    @Override
    public int port() {
        return this.httpConnector.getLocalPort();
    }

    @Override
    public int httpsPort() {
        return this.httpsConnector.getLocalPort();
    }

    public long stopTimeout() {
        return this.jettyServer.getStopTimeout();
    }

    protected abstract ServerConnector createHttpConnector(String var1, int var2, JettySettings var3, NetworkTrafficListener var4);

    protected abstract ServerConnector createHttpsConnector(String var1, HttpsSettings var2, JettySettings var3, NetworkTrafficListener var4);

    private ServletContextHandler addMockServiceContext(StubRequestHandler stubRequestHandler, FileSource fileSource, AsynchronousResponseSettings asynchronousResponseSettings, Options.ChunkedEncodingPolicy chunkedEncodingPolicy, boolean stubCorsEnabled, boolean browserProxyingEnabled, Notifier notifier) {
        ServletContextHandler mockServiceContext = new ServletContextHandler(this.jettyServer, "/");
        mockServiceContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.maxCacheSize", "0");
        mockServiceContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.resourceBase", fileSource.getPath());
        mockServiceContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        mockServiceContext.addServlet(DefaultServlet.class, FILES_URL_MATCH);
        mockServiceContext.setAttribute(JettyFaultInjectorFactory.class.getName(), new JettyFaultInjectorFactory());
        mockServiceContext.setAttribute(StubRequestHandler.class.getName(), stubRequestHandler);
        mockServiceContext.setAttribute("Notifier", notifier);
        mockServiceContext.setAttribute(Options.ChunkedEncodingPolicy.class.getName(), (Object)chunkedEncodingPolicy);
        mockServiceContext.setAttribute("browserProxyingEnabled", browserProxyingEnabled);
        ServletHolder servletHolder = mockServiceContext.addServlet(WireMockHandlerDispatchingServlet.class, "/");
        servletHolder.setInitOrder(1);
        servletHolder.setInitParameter("RequestHandlerClass", StubRequestHandler.class.getName());
        servletHolder.setInitParameter("FaultHandlerFactoryClass", JettyFaultInjectorFactory.class.getName());
        servletHolder.setInitParameter("shouldForwardToFilesContext", "true");
        if (asynchronousResponseSettings.isEnabled()) {
            this.scheduledExecutorService = Executors.newScheduledThreadPool(asynchronousResponseSettings.getThreads());
            mockServiceContext.setAttribute(WireMockHandlerDispatchingServlet.ASYNCHRONOUS_RESPONSE_EXECUTOR, this.scheduledExecutorService);
        }
        mockServiceContext.setAttribute(MultipartRequestConfigurer.KEY, this.buildMultipartRequestConfigurer());
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("json", "application/json");
        mimeTypes.addMimeMapping("html", "text/html");
        mimeTypes.addMimeMapping("xml", "application/xml");
        mimeTypes.addMimeMapping("txt", "text/plain");
        mockServiceContext.setMimeTypes(mimeTypes);
        mockServiceContext.setWelcomeFiles(new String[]{"index.json", "index.html", "index.xml", "index.txt"});
        NotFoundHandler errorHandler = new NotFoundHandler(mockServiceContext);
        mockServiceContext.setErrorHandler(errorHandler);
        mockServiceContext.addFilter(ContentTypeSettingFilter.class, FILES_URL_MATCH, EnumSet.of(DispatcherType.FORWARD));
        mockServiceContext.addFilter(TrailingSlashFilter.class, FILES_URL_MATCH, EnumSet.allOf(DispatcherType.class));
        if (stubCorsEnabled) {
            this.addCorsFilter(mockServiceContext);
        }
        return mockServiceContext;
    }

    private ServletContextHandler addAdminContext(AdminRequestHandler adminRequestHandler, Notifier notifier) {
        ServletContextHandler adminContext = new ServletContextHandler(this.jettyServer, "/__admin");
        adminContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.maxCacheSize", "0");
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor != null && javaVendor.toLowerCase().contains("android")) {
            adminContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.resourceBase", "assets");
        } else {
            adminContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.resourceBase", ResourceUtil.getResource(JettyHttpServer.class, "assets").toString());
        }
        ResourceUtil.getResource(JettyHttpServer.class, "assets/swagger-ui/index.html");
        adminContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        ServletHolder swaggerUiServletHolder = adminContext.addServlet(DefaultServlet.class, "/swagger-ui/*");
        swaggerUiServletHolder.setAsyncSupported(false);
        adminContext.addServlet(DefaultServlet.class, "/recorder/*");
        ServletHolder servletHolder = adminContext.addServlet(WireMockHandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", AdminRequestHandler.class.getName());
        adminContext.setAttribute(AdminRequestHandler.class.getName(), adminRequestHandler);
        adminContext.setAttribute("Notifier", notifier);
        adminContext.setAttribute(MultipartRequestConfigurer.KEY, this.buildMultipartRequestConfigurer());
        adminContext.addServlet(NotMatchedServlet.class, "/not-matched");
        this.addCorsFilter(adminContext);
        return adminContext;
    }

    private void addCorsFilter(ServletContextHandler context) {
        context.addFilter(this.buildCorsFilter(), "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private FilterHolder buildCorsFilter() {
        FilterHolder filterHolder = new FilterHolder(CrossOriginFilter.class);
        filterHolder.setInitParameters(Map.of("chainPreflight", "false", "allowedOrigins", "*", "allowedHeaders", "*", "allowedMethods", "OPTIONS,GET,POST,PUT,PATCH,DELETE"));
        return filterHolder;
    }

    protected MultipartRequestConfigurer buildMultipartRequestConfigurer() {
        return new DefaultMultipartRequestConfigurer();
    }

    private static class NetworkTrafficListenerAdapter
    implements NetworkTrafficListener {
        private final WiremockNetworkTrafficListener wiremockNetworkTrafficListener;

        NetworkTrafficListenerAdapter(WiremockNetworkTrafficListener wiremockNetworkTrafficListener) {
            this.wiremockNetworkTrafficListener = wiremockNetworkTrafficListener;
        }

        @Override
        public void opened(Socket socket) {
            this.wiremockNetworkTrafficListener.opened(socket);
        }

        @Override
        public void incoming(Socket socket, ByteBuffer bytes) {
            this.wiremockNetworkTrafficListener.incoming(socket, bytes);
        }

        @Override
        public void outgoing(Socket socket, ByteBuffer bytes) {
            this.wiremockNetworkTrafficListener.outgoing(socket, bytes);
        }

        @Override
        public void closed(Socket socket) {
            this.wiremockNetworkTrafficListener.closed(socket);
        }
    }
}

