/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.ssl;

import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.http.ssl.CertificateGenerationUnsupportedException;
import com.github.tomakehurst.wiremock.http.ssl.DelegatingX509ExtendedKeyManager;
import com.github.tomakehurst.wiremock.http.ssl.DynamicKeyStore;
import com.github.tomakehurst.wiremock.http.ssl.HostNameMatcher;
import java.net.Socket;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;

public class CertificateGeneratingX509ExtendedKeyManager
extends DelegatingX509ExtendedKeyManager {
    private final DynamicKeyStore dynamicKeyStore;
    private final HostNameMatcher hostNameMatcher;
    private final OnceOnlyNotifier notifier;

    public CertificateGeneratingX509ExtendedKeyManager(X509ExtendedKeyManager keyManager, DynamicKeyStore dynamicKeyStore, HostNameMatcher hostNameMatcher, Notifier notifier) {
        super(keyManager);
        this.dynamicKeyStore = Objects.requireNonNull(dynamicKeyStore);
        this.hostNameMatcher = Objects.requireNonNull(hostNameMatcher);
        this.notifier = new OnceOnlyNotifier(notifier);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        PrivateKey original = super.getPrivateKey(alias);
        return original != null ? original : this.dynamicKeyStore.getPrivateKey(alias);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] original = super.getCertificateChain(alias);
        return original != null ? original : this.dynamicKeyStore.getCertificateChain(alias);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        String defaultAlias = super.chooseServerAlias(keyType, issuers, socket);
        ExtendedSSLSession handshakeSession = this.getHandshakeSession(socket);
        return this.tryToChooseServerAlias(keyType, defaultAlias, handshakeSession);
    }

    private ExtendedSSLSession getHandshakeSession(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession sslSession = this.getHandshakeSessionIfSupported(sslSocket);
            return CertificateGeneratingX509ExtendedKeyManager.getHandshakeSession(sslSession);
        }
        return null;
    }

    private SSLSession getHandshakeSessionIfSupported(SSLSocket sslSocket) {
        try {
            return sslSocket.getHandshakeSession();
        }
        catch (UnsupportedOperationException e) {
            this.notify("your SSL Provider does not support SSLSocket.getHandshakeSession()", e);
            return null;
        }
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        String defaultAlias = super.chooseEngineServerAlias(keyType, issuers, engine);
        ExtendedSSLSession handshakeSession = this.getHandshakeSession(engine);
        return this.tryToChooseServerAlias(keyType, defaultAlias, handshakeSession);
    }

    private ExtendedSSLSession getHandshakeSession(SSLEngine sslEngine) {
        SSLSession sslSession = this.getHandshakeSessionIfSupported(sslEngine);
        return CertificateGeneratingX509ExtendedKeyManager.getHandshakeSession(sslSession);
    }

    private SSLSession getHandshakeSessionIfSupported(SSLEngine sslEngine) {
        try {
            return sslEngine.getHandshakeSession();
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            this.notify("your SSL Provider does not support SSLEngine.getHandshakeSession()", e);
            return null;
        }
    }

    private static ExtendedSSLSession getHandshakeSession(SSLSession handshakeSession) {
        if (handshakeSession instanceof ExtendedSSLSession) {
            return (ExtendedSSLSession)handshakeSession;
        }
        return null;
    }

    private String tryToChooseServerAlias(String keyType, String defaultAlias, ExtendedSSLSession handshakeSession) {
        if (defaultAlias != null && handshakeSession != null) {
            return this.chooseServerAlias(keyType, defaultAlias, handshakeSession);
        }
        return defaultAlias;
    }

    private String chooseServerAlias(String keyType, String defaultAlias, ExtendedSSLSession handshakeSession) {
        List<SNIHostName> requestedServerNames = this.getSNIHostNames(handshakeSession);
        if (requestedServerNames.isEmpty()) {
            return defaultAlias;
        }
        return this.chooseServerAlias(keyType, defaultAlias, requestedServerNames);
    }

    private List<SNIHostName> getSNIHostNames(ExtendedSSLSession handshakeSession) {
        List<SNIServerName> requestedServerNames = this.getRequestedServerNames(handshakeSession);
        return requestedServerNames.stream().filter(SNIHostName.class::isInstance).map(SNIHostName.class::cast).collect(Collectors.toList());
    }

    private List<SNIServerName> getRequestedServerNames(ExtendedSSLSession handshakeSession) {
        try {
            return handshakeSession.getRequestedServerNames();
        }
        catch (UnsupportedOperationException e) {
            this.notify("your SSL Provider does not support ExtendedSSLSession.getRequestedServerNames()", e);
            return Collections.emptyList();
        }
    }

    private String chooseServerAlias(String keyType, String defaultAlias, List<SNIHostName> requestedServerNames) {
        X509Certificate[] certificateChain = super.getCertificateChain(defaultAlias);
        if (certificateChain != null && this.matches(certificateChain[0], requestedServerNames)) {
            return defaultAlias;
        }
        try {
            SNIHostName requestedServerName = requestedServerNames.get(0);
            this.dynamicKeyStore.generateCertificateIfNecessary(keyType, requestedServerName);
            return requestedServerName.getAsciiName();
        }
        catch (CertificateGenerationUnsupportedException | KeyStoreException e) {
            this.notify("certificates cannot be generated; perhaps the sun internal classes are not available?", e);
            return defaultAlias;
        }
    }

    private boolean matches(X509Certificate x509Certificate, List<SNIHostName> requestedServerNames) {
        return requestedServerNames.stream().anyMatch(sniHostName -> this.hostNameMatcher.matches(x509Certificate, (SNIHostName)sniHostName));
    }

    private void notify(String reason, Exception e) {
        this.notifier.error("Dynamic certificate generation is not supported because " + reason + System.lineSeparator() + "All sites will be served using the normal WireMock HTTPS certificate.", e);
    }

    private static class OnceOnly {
        private final AtomicBoolean used = new AtomicBoolean(false);

        private OnceOnly() {
        }

        boolean unused() {
            return this.used.compareAndSet(false, true);
        }
    }

    private static class OnceOnlyNotifier
    implements Notifier {
        private final Notifier notifier;
        private final OnceOnly onceOnly = new OnceOnly();

        private OnceOnlyNotifier(Notifier notifier) {
            this.notifier = notifier;
        }

        @Override
        public void info(String message) {
            if (this.onceOnly.unused()) {
                this.notifier.info(message);
            }
        }

        @Override
        public void error(String message) {
            if (this.onceOnly.unused()) {
                this.notifier.error(message);
            }
        }

        @Override
        public void error(String message, Throwable t2) {
            if (this.onceOnly.unused()) {
                this.notifier.error(message, t2);
            }
        }
    }
}

