/*
 * Decompiled with CFR 0.152.
 */
package ignored;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.JvmProxyConfigurer;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class JUnit5ProxyTest {
    @RegisterExtension
    public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().enableBrowserProxying(true)).build();
    CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().build();

    @BeforeEach
    public void init() {
        JvmProxyConfigurer.configureFor((int)this.wm.getPort());
    }

    @AfterEach
    public void cleanup() {
        JvmProxyConfigurer.restorePrevious();
    }

    @Test
    public void testViaProxyUsingRule() throws Exception {
        this.wm.stubFor(WireMock.get((String)"/things").withHost(WireMock.equalTo((String)"my.first.domain")).willReturn(WireMock.ok((String)"Domain 1")));
        this.wm.stubFor(WireMock.get((String)"/things").withHost(WireMock.equalTo((String)"my.second.domain")).willReturn(WireMock.ok((String)"Domain 2")));
        CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)new HttpGet("http://my.first.domain/things"));
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        Assertions.assertEquals((Object)"Domain 1", (Object)responseBody);
        response = this.httpClient.execute((ClassicHttpRequest)new HttpGet("http://my.second.domain/things"));
        responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        Assertions.assertEquals((Object)"Domain 2", (Object)responseBody);
    }

    @Test
    public void testViaProxyUsingServer() throws Exception {
        WireMockServer wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().dynamicPort().enableBrowserProxying(true));
        wireMockServer.start();
        JvmProxyConfigurer.configureFor((WireMockServer)wireMockServer);
        wireMockServer.stubFor(WireMock.get((String)"/things").withHost(WireMock.equalTo((String)"my.first.domain")).willReturn(WireMock.ok((String)"Domain 1")));
        wireMockServer.stubFor(WireMock.get((String)"/things").withHost(WireMock.equalTo((String)"my.second.domain")).willReturn(WireMock.ok((String)"Domain 2")));
        CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)new HttpGet("http://my.first.domain/things"));
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        Assertions.assertEquals((Object)"Domain 1", (Object)responseBody);
        response = this.httpClient.execute((ClassicHttpRequest)new HttpGet("http://my.second.domain/things"));
        responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        Assertions.assertEquals((Object)"Domain 2", (Object)responseBody);
        wireMockServer.stop();
        JvmProxyConfigurer.restorePrevious();
    }
}

