/*
 * Decompiled with CFR 0.152.
 */
package ignored;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.DateTimeTruncation;
import com.github.tomakehurst.wiremock.common.DateTimeUnit;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilterAction;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestWrapper;
import com.github.tomakehurst.wiremock.extension.requestfilter.StubRequestFilter;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.github.tomakehurst.wiremock.recording.RecordSpecBuilder;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Examples
extends AcceptanceTestBase {
    @Test
    public void exactUrlOnly() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/some/thing")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"text/plain"}).withBody("Hello world!")));
        MatcherAssert.assertThat((Object)testClient.get("/some/thing", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.get("/some/thing/else", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void urlRegexMatch() {
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlMatching((String)"/thing/matching/[0-9]+")).willReturn(WireMock.aResponse().withStatus(200)));
    }

    @Test
    public void headerMatching() {
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/with/headers")).withHeader("Content-Type", WireMock.equalTo((String)"text/xml")).withHeader("Accept", WireMock.matching((String)"text/.*")).withHeader("etag", WireMock.notMatching((String)"abcd.*")).withHeader("etag", WireMock.containing((String)"2134")).willReturn(WireMock.aResponse().withStatus(200)));
    }

    @Test
    public void bodyMatching() {
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/with/body")).withRequestBody((ContentPattern)WireMock.matching((String)"<status>OK</status>")).withRequestBody((ContentPattern)WireMock.notMatching((String)"<status>ERROR</status>")).willReturn(WireMock.aResponse().withStatus(200)));
    }

    @Test
    public void binaryBodyMatchingByteArray() {
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/with/body")).withRequestBody((ContentPattern)WireMock.binaryEqualTo((byte[])new byte[]{1, 2, 3})).willReturn(WireMock.ok()));
    }

    @Test
    public void binaryBodyMatchingBase64() {
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/with/body")).withRequestBody((ContentPattern)WireMock.binaryEqualTo((String)"AQID")).willReturn(WireMock.ok()));
    }

    @Test
    public void multipartBodyMatchingBase64() {
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/with/multipart")).withMultipartRequestBody(WireMock.aMultipart().withBody((ContentPattern)WireMock.binaryEqualTo((String)"Content"))).willReturn(WireMock.ok()));
    }

    @Test
    public void priorities() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)"/api/.*")).atPriority(Integer.valueOf(5)).willReturn(WireMock.aResponse().withStatus(401)));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/api/specific-resource")).atPriority(Integer.valueOf(1)).willReturn(WireMock.aResponse().withStatus(200).withBody("Resource state")));
    }

    @Test
    public void responseHeaders() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/whatever")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withHeader("Etag", new String[]{"b13894794wb"})));
    }

    @Test
    public void bodyFile() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/body-file")).willReturn(WireMock.aResponse().withBodyFile("path/to/myfile.xml")));
    }

    @Test
    public void binaryBody() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/binary-body")).willReturn(WireMock.aResponse().withBody(new byte[]{1, 2, 3, 4})));
    }

    @Test
    public void verifyAtLeastOnce() {
        Assertions.assertThrows(VerificationException.class, () -> {
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/verify/this")).withHeader("Content-Type", WireMock.equalTo((String)"text/xml")));
            WireMock.verify((int)3, (RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/3/of/these")));
        });
    }

    @Test
    public void verifyWithoutHeader() {
        Assertions.assertThrows(VerificationException.class, () -> WireMock.verify((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/without/header")).withoutHeader("Content-Type")));
    }

    @Test
    public void findingRequests() {
        List requests = WireMock.findAll((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlMatching((String)"/api/.*")));
    }

    @Test
    public void proxying() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)"/other/service/.*")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("http://otherhost.com/approot")));
    }

    @Test
    public void proxyIntercept() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)".*")).atPriority(Integer.valueOf(10)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("http://otherhost.com")));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/api/override/123")).atPriority(Integer.valueOf(1)).willReturn(WireMock.aResponse().withStatus(503)));
    }

    @Test
    public void toDoListScenario() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/todo/items")).inScenario("To do list").whenScenarioStateIs("Started").willReturn(WireMock.aResponse().withBody("<items>   <item>Buy milk</item></items>")));
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/todo/items")).inScenario("To do list").whenScenarioStateIs("Started").withRequestBody((ContentPattern)WireMock.containing((String)"Cancel newspaper subscription")).willReturn(WireMock.aResponse().withStatus(201)).willSetStateTo("Cancel newspaper item added"));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/todo/items")).inScenario("To do list").whenScenarioStateIs("Cancel newspaper item added").willReturn(WireMock.aResponse().withBody("<items>   <item>Buy milk</item>   <item>Cancel newspaper subscription</item></items>")));
        WireMockResponse response = testClient.get("/todo/items", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"Buy milk"));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Cancel newspaper subscription")));
        response = testClient.postWithBody("/todo/items", "Cancel newspaper subscription", "text/plain", "UTF-8");
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)201));
        response = testClient.get("/todo/items", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"Buy milk"));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"Cancel newspaper subscription"));
    }

    @Test
    public void delay() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/delayed")).willReturn(WireMock.aResponse().withStatus(200).withFixedDelay(Integer.valueOf(2000))));
    }

    @Test
    public void fault() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/fault")).willReturn(WireMock.aResponse().withFault(Fault.MALFORMED_RESPONSE_CHUNK)));
    }

    @Test
    public void xpath() {
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/xpath")).withRequestBody((ContentPattern)WireMock.matchingXPath((String)"/todo-list[count(todo-item) = 3]")).willReturn(WireMock.aResponse().withStatus(200)));
    }

    @Test
    public void xpathWithNamespaces() {
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/namespaced/xpath")).withRequestBody((ContentPattern)WireMock.matchingXPath((String)"/stuff:outer/stuff:inner[.=111]").withXPathNamespace("stuff", "http://foo.com")).willReturn(WireMock.aResponse().withStatus(200)));
    }

    @Test
    public void advancedXPathMatching() {
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/xpath")).withRequestBody((ContentPattern)WireMock.matchingXPath((String)"//todo-item/text()", (StringValuePattern)WireMock.containing((String)"wash"))).willReturn(WireMock.aResponse().withStatus(200)));
    }

    @Test
    public void advancedJSONPathMatching() {
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/jsonpath")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$..todoItem", (StringValuePattern)WireMock.containing((String)"wash"))).willReturn(WireMock.aResponse().withStatus(200)));
    }

    @Test
    public void advancedJSONPathMatchingWithObject() {
        System.out.println(WireMock.matchingJsonPath((String)"$.outer", (StringValuePattern)WireMock.equalToJson((String)"{\n        \"inner\": 42\n    }")).match((Object)"{\n    \"outer\": {\n        \"inner\": 42\n    }\n}").isExactMatch());
    }

    @Test
    public void transformerParameters() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/transform")).willReturn(WireMock.aResponse().withTransformerParameter("newValue", (Object)66).withTransformerParameter("inner", Map.of("thing", "value"))));
        System.out.println(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/transform")).willReturn(WireMock.aResponse().withTransformerParameter("newValue", (Object)66).withTransformerParameter("inner", Map.of("thing", "value"))).build());
    }

    @Test
    public void transformerWithParameters() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/transform")).willReturn(WireMock.aResponse().withTransformer("body-transformer", "newValue", (Object)66)));
        System.out.println(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/transform")).willReturn(WireMock.aResponse().withTransformer("body-transformer", "newValue", (Object)66)).build());
    }

    @Test
    public void customMatcherName() {
        WireMock.stubFor((MappingBuilder)WireMock.requestMatching((String)"body-too-long", (Parameters)Parameters.one((String)"maxLemgth", (Object)2048)).willReturn(WireMock.aResponse().withStatus(422)));
        System.out.println(WireMock.requestMatching((String)"body-too-long", (Parameters)Parameters.one((String)"maxLemgth", (Object)2048)).willReturn(WireMock.aResponse().withStatus(422)).build());
    }

    @Test
    public void customMatcher() {
        wireMockServer.stubFor(WireMock.requestMatching((ValueMatcher)new RequestMatcherExtension(){

            public MatchResult match(Request request, Parameters parameters) {
                return MatchResult.of((request.getBody().length > 2048 ? 1 : 0) != 0, (SubEvent[])new SubEvent[0]);
            }
        }).willReturn(WireMock.aResponse().withStatus(422)));
    }

    @Test
    public void tmp() {
        System.out.println(Json.write((Object)WireMock.any((UrlPattern)WireMock.urlPathEqualTo((String)"/everything")).withHeader("Accept", WireMock.containing((String)"xml")).withCookie("session", WireMock.matching((String)".*12345.*")).withQueryParam("search_term", WireMock.equalTo((String)"WireMock")).withBasicAuth("jeff@example.com", "jeffteenjefftyjeff").withRequestBody((ContentPattern)WireMock.equalToXml((String)"<search-results />")).withRequestBody((ContentPattern)WireMock.matchingXPath((String)"//search-results")).withMultipartRequestBody(WireMock.aMultipart().withName("info").withHeader("Content-Type", WireMock.containing((String)"charset")).withBody((ContentPattern)WireMock.equalToJson((String)"{}"))).willReturn(WireMock.aResponse()).build()));
        WireMock.stubFor((MappingBuilder)WireMock.any((UrlPattern)WireMock.urlPathEqualTo((String)"/everything")).withHeader("Accept", WireMock.containing((String)"xml")).withCookie("session", WireMock.matching((String)".*12345.*")).withQueryParam("search_term", WireMock.equalTo((String)"WireMock")).withBasicAuth("jeff@example.com", "jeffteenjefftyjeff").withRequestBody((ContentPattern)WireMock.equalToXml((String)"<search-results />")).withRequestBody((ContentPattern)WireMock.matchingXPath((String)"//search-results")).withMultipartRequestBody(WireMock.aMultipart().withName("info").withHeader("Content-Type", WireMock.containing((String)"charset")).withBody((ContentPattern)WireMock.equalToJson((String)"{}"))).willReturn(WireMock.aResponse()));
    }

    @Test
    public void removeStubMapping() {
        StubMapping stubMapping = WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/delete-me")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/delete-me", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        WireMock.removeStub((StubMapping)stubMapping);
        MatcherAssert.assertThat((Object)testClient.get("/delete-me", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void servedStubs() {
        List allServeEvents = WireMock.getAllServeEvents();
    }

    @Test
    public void configuration() {
        WireMockConfiguration.options().port(8000).httpDisabled(true).httpsPort(Integer.valueOf(8001)).dynamicPort().dynamicHttpsPort().bindAddress("192.168.1.111").containerThreads(Integer.valueOf(5)).jettyAcceptors(Integer.valueOf(4)).jettyAcceptQueueSize(Integer.valueOf(100)).jettyHeaderBufferSize(Integer.valueOf(16834)).jettyHeaderRequestSize(Integer.valueOf(16834)).jettyHeaderResponseSize(Integer.valueOf(16834)).jettyStopTimeout(Long.valueOf(5000L)).keystorePath("/path/to/https-certs-keystore.jks").keystorePassword("verysecret!").needClientAuth(true).trustStorePath("/path/to/trust-store.jks").trustStorePassword("trustme").enableBrowserProxying(true).preserveHostHeader(false).proxyHostHeader("my.otherdomain.com").proxyVia("my.corporate.proxy", 8080).usingFilesUnderDirectory("/path/to/files-and-mappings-root").usingFilesUnderClasspath("root/path/under/classpath").disableRequestJournal().maxRequestJournalEntries(100).notifier((Notifier)new ConsoleNotifier(true));
    }

    @Test
    public void abbreviatedDsl() {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/some/thing").willReturn(WireMock.aResponse().withStatus(200)));
        WireMock.stubFor((MappingBuilder)WireMock.delete((String)"/fine").willReturn(WireMock.ok()));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/json").willReturn(WireMock.okJson((String)"{ \"message\": \"Hello\" }")));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/xml").willReturn(WireMock.okXml((String)"<hello />")));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/xml").willReturn(WireMock.okTextXml((String)"<hello />")));
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/things").willReturn(WireMock.noContent()));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/json-from-string").willReturn(WireMock.jsonResponse((String)"{ \"message\": \"String Json\" }", (int)200)));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/json-from-object").willReturn(WireMock.jsonResponse((Object)new MockResponse("Object Json"), (int)200)));
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/temp-redirect").willReturn(WireMock.temporaryRedirect((String)"/new/place")));
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/perm-redirect").willReturn(WireMock.permanentRedirect((String)"/new/place")));
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/see-other").willReturn(WireMock.seeOther((String)"/new/place")));
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/sorry-no").willReturn(WireMock.unauthorized()));
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/still-no").willReturn(WireMock.forbidden()));
        WireMock.stubFor((MappingBuilder)WireMock.put((String)"/dodgy").willReturn(WireMock.badRequest()));
        WireMock.stubFor((MappingBuilder)WireMock.put((String)"/dodgy-body").willReturn(WireMock.badRequestEntity()));
        WireMock.stubFor((MappingBuilder)WireMock.put((String)"/nothing-to-see-here").willReturn(WireMock.notFound()));
        WireMock.stubFor((MappingBuilder)WireMock.put((String)"/status-only").willReturn(WireMock.status((int)418)));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/dead-server").willReturn(WireMock.serviceUnavailable()));
        WireMock.stubFor((MappingBuilder)WireMock.put((String)"/error").willReturn(WireMock.serverError()));
        WireMock.stubFor((MappingBuilder)WireMock.proxyAllTo((String)"http://my.example.com"));
    }

    @Test
    public void recordingDsl() {
        WireMock.startRecording((RecordSpecBuilder)WireMock.recordSpec().forTarget("http://example.mocklab.io").onlyRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/api/.*"))).captureHeader("Accept").captureHeader("Content-Type", Boolean.valueOf(true)).extractBinaryBodiesOver(10240L).extractTextBodiesOver(2048L).makeStubsPersistent(false).ignoreRepeatRequests().transformers(new String[]{"modify-response-header"}).transformerParameters(Parameters.one((String)"headerValue", (Object)"123")).matchRequestBodyWithEqualToJson(Boolean.valueOf(false), Boolean.valueOf(true)));
        System.out.println(Json.write((Object)WireMock.recordSpec().forTarget("http://example.mocklab.io").onlyRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/api/.*"))).captureHeader("Accept").captureHeader("Content-Type", Boolean.valueOf(true)).extractBinaryBodiesOver(10240L).extractTextBodiesOver(2048L).makeStubsPersistent(false).ignoreRepeatRequests().transformers(new String[]{"modify-response-header"}).transformerParameters(Parameters.one((String)"headerValue", (Object)"123")).matchRequestBodyWithEqualToJson(Boolean.valueOf(false), Boolean.valueOf(true)).build()));
    }

    @Test
    public void snapshotDsl() {
        WireMock.snapshotRecord((RecordSpecBuilder)WireMock.recordSpec().onlyRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/api/.*"))).onlyRequestIds(Collections.singletonList(UUID.fromString("40a93c4a-d378-4e07-8321-6158d5dbcb29"))).captureHeader("Accept").captureHeader("Content-Type", Boolean.valueOf(true)).extractBinaryBodiesOver(10240L).extractTextBodiesOver(2048L).makeStubsPersistent(false).ignoreRepeatRequests().transformers(new String[]{"modify-response-header"}).transformerParameters(Parameters.one((String)"headerValue", (Object)"123")).chooseBodyMatchTypeAutomatically());
        System.out.println(Json.write((Object)WireMock.recordSpec().onlyRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/api/.*"))).onlyRequestIds(Collections.singletonList(UUID.fromString("40a93c4a-d378-4e07-8321-6158d5dbcb29"))).captureHeader("Accept").captureHeader("Content-Type", Boolean.valueOf(true)).extractBinaryBodiesOver(10240L).extractTextBodiesOver(2048L).makeStubsPersistent(false).ignoreRepeatRequests().transformers(new String[]{"modify-response-header"}).transformerParameters(Parameters.one((String)"headerValue", (Object)"123")).chooseBodyMatchTypeAutomatically().build()));
    }

    @Test
    public void customAndStandardMatcherJson() {
        System.out.println(Json.write((Object)WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/the/.*/one")).andMatching("path-contains-param", Parameters.one((String)"path", (Object)"correct")).willReturn(WireMock.ok()).build()));
    }

    @Test
    public void dates() {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/dates").withHeader("X-Munged-Date", (StringValuePattern)WireMock.beforeNow().expectedOffset(3, DateTimeUnit.DAYS)).withHeader("X-Finalised-Date", (StringValuePattern)WireMock.before((String)"now +2 months")).willReturn(WireMock.ok()));
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/dates").withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.completedDate", (StringValuePattern)WireMock.equalToDateTime((String)"2020-03-01T00:00:00Z").truncateActual(DateTimeTruncation.FIRST_DAY_OF_MONTH))).willReturn(WireMock.ok()));
        System.out.println(Json.write((Object)WireMock.post((String)"/dates").withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.completedDate", (StringValuePattern)WireMock.equalToDateTime((String)"2020-03-01T00:00:00Z").truncateActual(DateTimeTruncation.FIRST_DAY_OF_MONTH))).willReturn(WireMock.ok()).build()));
    }

    @Test
    public void logicalAnd() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/and")).withHeader("X-Some-Value", WireMock.and((StringValuePattern[])new StringValuePattern[]{WireMock.matching((String)"[a-z]+"), WireMock.containing((String)"magicvalue")})).willReturn(WireMock.ok()));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/and")).withHeader("X-Some-Value", (StringValuePattern)WireMock.matching((String)"[a-z]+").and(WireMock.containing((String)"magicvalue"))).willReturn(WireMock.ok()));
        System.out.println(Json.write((Object)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/and")).withHeader("X-Some-Value", (StringValuePattern)WireMock.matching((String)"[a-z]+").and(WireMock.containing((String)"magicvalue"))).willReturn(WireMock.ok()).build()));
    }

    @Test
    public void logicalOr() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/or")).withQueryParam("search", WireMock.or((StringValuePattern[])new StringValuePattern[]{WireMock.matching((String)"[a-z]+"), WireMock.absent()})).willReturn(WireMock.ok()));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/or")).withQueryParam("search", (StringValuePattern)WireMock.matching((String)"[a-z]+").or(WireMock.absent())).willReturn(WireMock.ok()));
        System.out.println(Json.write((Object)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/or")).withQueryParam("search", (StringValuePattern)WireMock.matching((String)"[a-z]+").or(WireMock.absent())).willReturn(WireMock.ok()).build()));
    }

    @Test
    public void jsonPathAndDates() {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/date-range").withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.date", (StringValuePattern)WireMock.before((String)"2022-01-01T00:00:00").and((StringValuePattern)WireMock.after((String)"2020-01-01T00:00:00")))).willReturn(WireMock.ok()));
        System.out.println(Json.write((Object)WireMock.post((String)"/date-range").withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.date", (StringValuePattern)WireMock.before((String)"2022-01-01T00:00:00").and((StringValuePattern)WireMock.after((String)"2020-01-01T00:00:00")))).willReturn(WireMock.ok()).build()));
    }

    public static class MockResponse {
        private final String message;

        public MockResponse(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class UrlAndHeadersModifyingFilter
    extends StubRequestFilter {
        public RequestFilterAction filter(Request request) {
            Request wrappedRequest = RequestWrapper.create().transformAbsoluteUrl(url -> url + "extraparam=123").addHeader("X-Custom-Header", new String[]{"headerval"}).wrap(request);
            return RequestFilterAction.continueWith((Request)wrappedRequest);
        }

        public String getName() {
            return "url-and-header-modifier";
        }
    }

    public static class SimpleAuthRequestFilter
    extends StubRequestFilter {
        public RequestFilterAction filter(Request request) {
            if (request.header("Authorization").firstValue().equals("Basic abc123")) {
                return RequestFilterAction.continueWith((Request)request);
            }
            return RequestFilterAction.stopWith((ResponseDefinition)ResponseDefinition.notAuthorised());
        }

        public String getName() {
            return "simple-auth";
        }
    }
}

