/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.testsupport;

import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.Message;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

public class ServeEventChecks {
    public static void assertMessageSubEventPresent(Admin admin, String type, String message) {
        admin.getServeEvents().getServeEvents().stream().findFirst().ifPresentOrElse(serveEvent -> {
            MatcherAssert.assertThat((Object)serveEvent.getSubEvents(), (Matcher)Matchers.hasSize((int)1));
            serveEvent.getSubEvents().stream().findFirst().ifPresentOrElse(subEvent -> {
                MatcherAssert.assertThat((Object)subEvent.getType(), (Matcher)Matchers.is((Object)type));
                MatcherAssert.assertThat((Object)Strings.normaliseLineBreaks((String)((Message)subEvent.getDataAs(Message.class)).getMessage()), (Matcher)Matchers.is((Object)Strings.normaliseLineBreaks((String)message)));
            }, () -> Assertions.fail((String)"No sub events found"));
        }, () -> Assertions.fail((String)"No serve events found"));
    }

    public static void checkMessage(MatchResult matchResult, String type, String message) {
        matchResult.getSubEvents().stream().filter(subEvent -> subEvent.getType().equals(type)).findFirst().ifPresentOrElse(subEvent -> MatcherAssert.assertThat((Object)Strings.normaliseLineBreaks((String)((Message)subEvent.getDataAs(Message.class)).getMessage()), (Matcher)Matchers.is((Object)Strings.normaliseLineBreaks((String)message))), () -> Assertions.fail((String)("No sub event of type " + type + " found")));
    }

    public static void checkJsonError(MatchResult matchResult, String detailMessage) {
        matchResult.getSubEvents().stream().filter(subEvent -> subEvent.getType().equals("JSON_ERROR")).findFirst().ifPresentOrElse(subEvent -> MatcherAssert.assertThat((Object)Strings.normaliseLineBreaks((String)((Errors)subEvent.getDataAs(Errors.class)).first().getDetail()), (Matcher)Matchers.is((Object)Strings.normaliseLineBreaks((String)detailMessage))), () -> Assertions.fail((String)"No sub event of type JSON_ERROR found"));
    }
}

