/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.SortedConcurrentMappingSet;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import java.util.Iterator;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SortedConcurrentMappingSetTest {
    private SortedConcurrentMappingSet mappingSet;

    @BeforeEach
    public void init() {
        this.mappingSet = new SortedConcurrentMappingSet();
    }

    @Test
    public void returnsMappingsInPriorityThenInsertionOrder() {
        this.mappingSet.add(this.aMapping(3, "/priority3/1"));
        this.mappingSet.add(this.aMapping(3, "/priority3/2"));
        this.mappingSet.add(this.aMapping(6, "/priority6/1"));
        this.mappingSet.add(this.aMapping(1, "/priority1/1"));
        this.mappingSet.add(this.aMapping(1, "/priority1/2"));
        this.mappingSet.add(this.aMapping(1, "/priority1/3"));
        MatcherAssert.assertThat((Object)this.mappingSet, WireMatchers.hasExactly(this.requestUrlIs("/priority1/3"), this.requestUrlIs("/priority1/2"), this.requestUrlIs("/priority1/1"), this.requestUrlIs("/priority3/2"), this.requestUrlIs("/priority3/1"), this.requestUrlIs("/priority6/1")));
    }

    @Test
    public void supportsNullPriority() {
        this.mappingSet.add(this.aMapping(null, "/1"));
        this.mappingSet.add(this.aMapping(null, "/2"));
        this.mappingSet.add(this.aMapping(null, "/3"));
        this.mappingSet.add(this.aMapping(null, "/4"));
        MatcherAssert.assertThat((Object)this.mappingSet, WireMatchers.hasExactly(this.requestUrlIs("/4"), this.requestUrlIs("/3"), this.requestUrlIs("/2"), this.requestUrlIs("/1")));
    }

    @Test
    public void clearsCorrectly() {
        this.mappingSet.add(this.aMapping(3, "/priority3/1"));
        this.mappingSet.add(this.aMapping(3, "/priority3/2"));
        this.mappingSet.add(this.aMapping(6, "/priority6/1"));
        this.mappingSet.add(this.aMapping(1, "/priority1/1"));
        this.mappingSet.clear();
        MatcherAssert.assertThat((String)"Mapping set should be empty", (Object)this.mappingSet.iterator().hasNext(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testRemove() throws Exception {
        StubMapping stubMapping = this.aMapping(1, "/priority1/1");
        this.mappingSet.add(stubMapping);
        MatcherAssert.assertThat((Object)this.mappingSet.iterator().hasNext(), (Matcher)Matchers.is((Object)true));
        this.mappingSet.remove(stubMapping);
        MatcherAssert.assertThat((Object)this.mappingSet.iterator().hasNext(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplace() throws Exception {
        StubMapping existingMapping = this.aMapping(1, "/priority1/1");
        this.mappingSet.add(existingMapping);
        existingMapping.setNewScenarioState("New Scenario State");
        StubMapping newMapping = this.aMapping(2, "/priority2/1");
        boolean result = this.mappingSet.replace(existingMapping, newMapping);
        Iterator it = this.mappingSet.iterator();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)it.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((StubMapping)it.next()), (Matcher)Matchers.is((Object)newMapping));
        MatcherAssert.assertThat((Object)it.hasNext(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplaceNotExists() throws Exception {
        StubMapping existingMapping = this.aMapping(1, "/priority1/1");
        this.mappingSet.add(existingMapping);
        StubMapping newMapping = this.aMapping(2, "/priority2/1");
        boolean result = this.mappingSet.replace(this.aMapping(2, "/priority2/2"), newMapping);
        Iterator it = this.mappingSet.iterator();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)it.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((StubMapping)it.next()), (Matcher)Matchers.is((Object)existingMapping));
        MatcherAssert.assertThat((Object)it.hasNext(), (Matcher)Matchers.is((Object)false));
    }

    private StubMapping aMapping(Integer priority, String url) {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)url)).build();
        StubMapping mapping = new StubMapping(requestPattern, new ResponseDefinition());
        mapping.setPriority(priority);
        return mapping;
    }

    private Matcher<StubMapping> requestUrlIs(final String expectedUrl) {
        return new TypeSafeMatcher<StubMapping>(){

            public void describeTo(Description desc) {
            }

            public boolean matchesSafely(StubMapping actualMapping) {
                return actualMapping.getRequest().getUrl().equals(expectedUrl);
            }
        };
    }
}

