/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store.files;

import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.store.files.BlobStoreFileSource;
import com.github.tomakehurst.wiremock.store.files.FileSourceBlobStore;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class BlobStoreFileSourceTest {
    static final String ROOT_PATH = TestFiles.filePath("filesource");
    BlobStoreFileSource fileSource;

    @BeforeEach
    void setup() {
        FileSourceBlobStore blobStore = new FileSourceBlobStore(ROOT_PATH);
        this.fileSource = new BlobStoreFileSource((BlobStore)blobStore);
    }

    @Test
    void list_all_files() {
        List files = this.fileSource.listFilesRecursively();
        MatcherAssert.assertThat((Object)files, WireMatchers.hasExactlyIgnoringOrder(WireMatchers.fileNamed("one"), WireMatchers.fileNamed("two"), WireMatchers.fileNamed("three"), WireMatchers.fileNamed("four"), WireMatchers.fileNamed("five"), WireMatchers.fileNamed("six"), WireMatchers.fileNamed("seven"), WireMatchers.fileNamed("eight"), WireMatchers.fileNamed("deepfile.json")));
    }

    @Test
    void get_single_file_bytes() {
        byte[] expected = "{}".getBytes();
        MatcherAssert.assertThat((Object)this.fileSource.getBinaryFileNamed("subdir/deepfile.json").readContents(), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    void get_single_stream() throws Exception {
        byte[] expected = "{}".getBytes();
        byte[] actual = ByteStreams.toByteArray((InputStream)this.fileSource.getBinaryFileNamed("subdir/deepfile.json").getStream());
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)expected));
    }

    @Test
    void write_binary_file(@TempDir Path tempDir) throws Exception {
        FileSourceBlobStore blobStore = new FileSourceBlobStore(tempDir.toString());
        this.fileSource = new BlobStoreFileSource((BlobStore)blobStore);
        byte[] contents = "{}".getBytes();
        this.fileSource.writeBinaryFile("folder/file.json", contents);
        byte[] actual = Files.toByteArray((File)tempDir.resolve("folder/file.json").toFile());
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)contents));
    }

    @Test
    void write_text_file(@TempDir Path tempDir) throws Exception {
        FileSourceBlobStore blobStore = new FileSourceBlobStore(tempDir.toString());
        this.fileSource = new BlobStoreFileSource((BlobStore)blobStore);
        String contents = "{}";
        this.fileSource.writeTextFile("folder/text-file.json", contents);
        String actual = new String(Files.toByteArray((File)tempDir.resolve("folder/text-file.json").toFile()));
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)contents));
    }

    @Test
    void delete_file(@TempDir Path tempDir) {
        FileSourceBlobStore blobStore = new FileSourceBlobStore(tempDir.toString());
        this.fileSource = new BlobStoreFileSource((BlobStore)blobStore);
        String filePath = "folder/tmp-file.json";
        this.fileSource.writeTextFile(filePath, "{}");
        MatcherAssert.assertThat((Object)tempDir.resolve(filePath).toFile().exists(), (Matcher)Matchers.is((Object)true));
        this.fileSource.deleteFile(filePath);
        MatcherAssert.assertThat((Object)tempDir.resolve(filePath).toFile().exists(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void delete_all_files(@TempDir Path tempDir) {
        FileSourceBlobStore blobStore = new FileSourceBlobStore(tempDir.toString());
        this.fileSource = new BlobStoreFileSource((BlobStore)blobStore);
        String filePath1 = "folder/tmp-file.json";
        String filePath2 = "root-tmp-file.json";
        this.fileSource.writeTextFile(filePath1, "{}");
        this.fileSource.writeTextFile(filePath2, "{}");
        MatcherAssert.assertThat((Object)tempDir.resolve(filePath1).toFile().exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)tempDir.resolve(filePath2).toFile().exists(), (Matcher)Matchers.is((Object)true));
        blobStore.clear();
        MatcherAssert.assertThat((Object)tempDir.resolve(filePath1).toFile().exists(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)tempDir.resolve(filePath2).toFile().exists(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void text_file_path() {
    }
}

