/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.extension.StubMappingTransformer;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingTransformerRunner;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.GlobalStubMappingTransformer;
import com.github.tomakehurst.wiremock.testsupport.NonGlobalStubMappingTransformer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnapshotStubMappingTransformerRunnerTest {
    private final StubMapping stubMapping = WireMock.get((String)"/").build();

    @Test
    public void applyWithNoTransformers() {
        StubMapping result = new SnapshotStubMappingTransformerRunner(new ArrayList()).apply(this.stubMapping);
        Assertions.assertEquals((Object)this.stubMapping, (Object)result);
    }

    @Test
    public void applyWithUnregisteredNonGlobalTransformer() {
        StubMapping result = new SnapshotStubMappingTransformerRunner((Iterable)Lists.newArrayList((Object[])new StubMappingTransformer[]{new NonGlobalStubMappingTransformer()})).apply(this.stubMapping);
        Assertions.assertEquals((Object)this.stubMapping, (Object)result);
    }

    @Test
    public void applyWithRegisteredNonGlobalTransformer() {
        StubMapping result = new SnapshotStubMappingTransformerRunner((Iterable)Lists.newArrayList((Object[])new StubMappingTransformer[]{new NonGlobalStubMappingTransformer()}), (List)Lists.newArrayList((Object[])new String[]{"nonglobal-transformer"}), null, null).apply(this.stubMapping);
        Assertions.assertEquals((Object)"/?transformed=nonglobal", (Object)result.getRequest().getUrl());
    }

    @Test
    public void applyWithGlobalTransformer() {
        StubMapping result = new SnapshotStubMappingTransformerRunner((Iterable)Lists.newArrayList((Object[])new StubMappingTransformer[]{new GlobalStubMappingTransformer()})).apply(this.stubMapping);
        Assertions.assertEquals((Object)"/?transformed=global", (Object)result.getRequest().getUrl());
    }
}

