/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.Limit;
import com.github.tomakehurst.wiremock.common.Timing;
import com.github.tomakehurst.wiremock.http.LoggedResponse;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.recording.LoggedResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.recording.RequestPatternTransformer;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingGenerator;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.MockRequestBuilder;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.concurrent.LinkedBlockingQueue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class SnapshotStubMappingGeneratorTest {
    @Test
    public void apply() {
        RequestPatternBuilder requestPatternBuilder = RequestPatternBuilder.newRequestPattern().withUrl("/foo");
        ResponseDefinition responseDefinition = ResponseDefinition.ok();
        SnapshotStubMappingGenerator stubMappingTransformer = new SnapshotStubMappingGenerator(SnapshotStubMappingGeneratorTest.requestPatternTransformer(requestPatternBuilder), SnapshotStubMappingGeneratorTest.responseDefinitionTransformer(responseDefinition));
        StubMapping actual = stubMappingTransformer.apply(SnapshotStubMappingGeneratorTest.serveEvent());
        StubMapping expected = new StubMapping(requestPatternBuilder.build(), responseDefinition);
        expected.setId(actual.getId());
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void applyWithStrangePathAndCheckSanitizedState() {
        RequestPatternBuilder requestPatternBuilder = RequestPatternBuilder.newRequestPattern().withUrl("hello_1_2_3___ace--ace___and");
        ResponseDefinition responseDefinition = ResponseDefinition.ok();
        SnapshotStubMappingGenerator stubMappingTransformer = new SnapshotStubMappingGenerator(SnapshotStubMappingGeneratorTest.requestPatternTransformer(requestPatternBuilder), SnapshotStubMappingGeneratorTest.responseDefinitionTransformer(responseDefinition));
        StubMapping actual = stubMappingTransformer.apply(SnapshotStubMappingGeneratorTest.serveEventWithPath("/hello/1/2/3__!/\u1eae\u010c\u0116--ace/\u00a5$$/$/and/\u00bf?"));
        StubMapping expected = new StubMapping(requestPatternBuilder.build(), responseDefinition);
        expected.setId(actual.getId());
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)expected));
    }

    private static RequestPatternTransformer requestPatternTransformer(final RequestPatternBuilder requestPatternBuilder) {
        return new RequestPatternTransformer(null, null){

            public RequestPatternBuilder apply(Request request) {
                return requestPatternBuilder;
            }
        };
    }

    private static LoggedResponseDefinitionTransformer responseDefinitionTransformer(final ResponseDefinition responseDefinition) {
        return new LoggedResponseDefinitionTransformer(){

            public ResponseDefinition apply(LoggedResponse response) {
                return responseDefinition;
            }
        };
    }

    private static ServeEvent serveEventWithPath(String path) {
        return ServeEvent.of((Request)LoggedRequest.createFrom((Request)MockRequestBuilder.aRequest().withUrl(path).build()));
    }

    private static ServeEvent serveEvent() {
        return new ServeEvent(null, LoggedRequest.createFrom((Request)MockRequestBuilder.aRequest().build()), null, null, LoggedResponse.from((Response)Response.notConfigured(), (Limit)Limit.UNLIMITED), false, Timing.UNTIMED, new LinkedBlockingQueue());
    }
}

