/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingBodyExtractor;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.store.files.FileSourceBlobStore;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class SnapshotStubMappingBodyExtractorTest {
    private FileSource filesSource;
    private SnapshotStubMappingBodyExtractor bodyExtractor;

    @BeforeEach
    public void init() {
        this.filesSource = (FileSource)Mockito.mock(FileSource.class, (String)"filesFileSource");
        this.bodyExtractor = new SnapshotStubMappingBodyExtractor((BlobStore)new FileSourceBlobStore(this.filesSource));
    }

    @Test
    public void updatesStubMapping() {
        StubMapping stubMapping = WireMock.get((String)"/foo").willReturn(WireMock.ok((String)"")).build();
        this.bodyExtractor.extractInPlace(stubMapping);
        MatcherAssert.assertThat((Object)stubMapping.getResponse().getBodyFileName(), (Matcher)Matchers.is((Object)("get-foo-" + stubMapping.getId() + ".txt")));
        MatcherAssert.assertThat((Object)stubMapping.getResponse().specifiesBodyFile(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)stubMapping.getResponse().specifiesBodyContent(), (Matcher)Matchers.is((Object)false));
        ((FileSource)Mockito.verify((Object)this.filesSource)).writeBinaryFile((String)ArgumentMatchers.any(String.class), (byte[])ArgumentMatchers.any(byte[].class));
    }

    @Test
    public void determinesFileNameProperlyFromUrlWithJson() {
        StubMapping stubMapping = WireMock.get((String)"/foo/bar.json").willReturn(WireMock.ok((String)"{}")).build();
        this.bodyExtractor.extractInPlace(stubMapping);
        this.verifyWriteBinaryFile("get-foobar.json-" + stubMapping.getId() + ".json", "{}");
    }

    @Test
    public void determinesFileNameProperlyFromUrlWithText() {
        StubMapping stubMapping = WireMock.get((String)"/foo/bar.txt").willReturn(WireMock.ok((String)"")).build();
        this.bodyExtractor.extractInPlace(stubMapping);
        this.verifyWriteBinaryFile("get-foobar.txt-" + stubMapping.getId() + ".txt", "");
    }

    @Test
    public void determinesFileNameProperlyFromMimeTypeWithJson() {
        StubMapping stubMapping = WireMock.get((String)"/foo/bar.txt").willReturn(WireMock.okJson((String)"{}")).build();
        this.bodyExtractor.extractInPlace(stubMapping);
        this.verifyWriteBinaryFile("get-foobar.txt-" + stubMapping.getId() + ".json", "{}");
    }

    @Test
    public void determinesFileNameProperlyWithNamedStubMapping() {
        StubMapping stubMapping = WireMock.get((String)"/foo").willReturn(WireMock.okJson((String)"{}")).build();
        stubMapping.setName("TEST NAME!");
        this.bodyExtractor.extractInPlace(stubMapping);
        this.verifyWriteBinaryFile("test-name-" + stubMapping.getId() + ".json", "{}");
    }

    private void verifyWriteBinaryFile(String filename, String body) {
        ((FileSource)Mockito.verify((Object)this.filesSource)).writeBinaryFile((String)ArgumentMatchers.eq((Object)filename), (byte[])ArgumentMatchers.eq((Object)body.getBytes()));
    }
}

